/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.orc;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.skill.unique.StarvedSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.orc.OrcLordRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class OrcDisasterRace
extends OrcLordRace {
    @Override
    public double getBaseHealth() {
        return 300.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 3.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.4;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.5;
    }

    @Override
    public double getSprintSpeed() {
        return 0.5;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)100000.0, (Object)100000.0);
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 40.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)ResistanceSkills.MAGIC_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.FLAME_ATTACK_RESISTANCE.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.SPIRIT_BOAR.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.SPIRIT_BOAR.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.ORC_LORD.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double EP = TensuraPlayerCapability.getBaseEP(player);
        double percentage = Math.min(EP / (Double)TensuraConfig.INSTANCE.racesConfig.epToDisaster.get() * 50.0, 50.0);
        if (SkillUtils.isSkillMastered((LivingEntity)player, (ManasSkill)UniqueSkills.STARVED.get())) {
            percentage += 50.0;
        }
        return percentage;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"tensura.evolution_menu.ep_requirement"));
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.mastery_requirement", (Object[])new Object[]{((StarvedSkill)UniqueSkills.STARVED.get()).getName()}));
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (!player.f_19853_.m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 40, 4, false, false, false));
    }
}

