/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.slime;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.slime.SlimeRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class DemonSlimeRace
extends SlimeRace {
    public DemonSlimeRace() {
        super(Race.Difficulty.EASY);
    }

    @Override
    public float getPlayerSize() {
        return 0.65f;
    }

    @Override
    public double getBaseHealth() {
        return 1000.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 3.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.5;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(3.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.2;
    }

    @Override
    public double getMovementSpeed() {
        return 0.11;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 50.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 3.0;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)400000.0, (Object)400000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)600000.0, (Object)600000.0);
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        return TensuraPlayerCapability.isTrueDemonLord(player) || TensuraPlayerCapability.isTrueHero((LivingEntity)player) ? 100.0 : 0.0;
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.awaken_requirement", (Object[])new Object[]{Component.m_237115_((String)"tensura.attribute.true_demon_lord.name").m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237115_((String)"tensura.attribute.true_hero.name").m_130940_(ChatFormatting.GOLD)}));
        return list;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)IntrinsicSkills.POSSESSION.get()));
        list.add((TensuraSkill)((Object)ExtraSkills.INFINITE_REGENERATION.get()));
        list.add((TensuraSkill)((Object)ExtraSkills.UNIVERSAL_PERCEPTION.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.PHYSICAL_ATTACK_NULLIFICATION.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.MAGIC_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.COLD_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.CORROSION_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.DARKNESS_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.EARTH_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.ELECTRICITY_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.GRAVITY_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.HEAT_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.LIGHT_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.SPATIAL_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.WATER_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.WIND_ATTACK_RESISTANCE.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.GOD_SLIME.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.GOD_SLIME.get();
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.GOD_SLIME.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.SLIME.get());
        list.add((Race)TensuraRaces.METAL_SLIME.get());
        return list;
    }

    @Override
    public boolean isSpiritual() {
        return true;
    }
}

