/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.slime;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.slime.SlimeRace;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class MetalSlimeRace
extends SlimeRace {
    public MetalSlimeRace() {
        super(Race.Difficulty.EASY);
    }

    @Override
    public double getBaseHealth() {
        return 100.0;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.2;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.4;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(2.0);
    }

    @Override
    public double getSprintSpeed() {
        return 0.15;
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)3000.0, (Object)3000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)7000.0, (Object)7000.0);
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        List<TensuraSkill> list = super.getIntrinsicSkills(player);
        list.add((TensuraSkill)((Object)IntrinsicSkills.BODY_ARMOR.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.COLD_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.CORROSION_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.DARKNESS_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.EARTH_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.ELECTRICITY_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.GRAVITY_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.HEAT_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.LIGHT_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.SPATIAL_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.WATER_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.WIND_ATTACK_RESISTANCE.get()));
        return list;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.DEMON_SLIME.get());
        return list;
    }

    @Override
    public List<Race> getPreviousEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.SLIME.get());
        return list;
    }

    @Override
    public double getEvolutionPercentage(Player player) {
        double ores = 0.0;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = (LocalPlayer)player;
            ores = localPlayer.m_108630_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMaterialItems.MAGIC_ORE.get())));
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ores = serverPlayer.m_8951_().m_13015_(Stats.f_12982_.m_12902_((Object)((Item)TensuraMaterialItems.MAGIC_ORE.get())));
        }
        return ores * 100.0 / (double)((Integer)TensuraConfig.INSTANCE.racesConfig.oreForMetalSlime.get()).intValue();
    }

    @Override
    public List<Component> getRequirementsForRendering(Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237110_((String)"tensura.evolution_menu.consume_requirement", (Object[])new Object[]{((Item)TensuraMaterialItems.MAGIC_ORE.get()).m_7968_().m_41611_()}));
        return list;
    }
}

