/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.slime;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.api.race.AdvancedHitbox;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class SlimeRace
extends Race
implements AdvancedHitbox {
    public static final int jumpChargeTicks = 60;

    public SlimeRace() {
        super(Race.Difficulty.EXTREME);
    }

    public SlimeRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 10.0;
    }

    @Override
    public float getPlayerSize() {
        return 0.5f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 0.3;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 4.0;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer(1.0);
    }

    @Override
    public double getMovementSpeed() {
        return 0.07;
    }

    @Override
    public double getSprintSpeed() {
        return 0.091;
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 20.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 2.5;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)200.0, (Object)500.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)200.0, (Object)500.0);
    }

    @Override
    public float getHitboxWidthModifier() {
        return 4.0f;
    }

    @Override
    public float getHitboxHeightModifier() {
        return 1.0f;
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)IntrinsicSkills.ABSORB_DISSOLVE.get()));
        list.add((TensuraSkill)((Object)CommonSkills.SELF_REGENERATION.get()));
        return list;
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.DEMON_SLIME.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.DEMON_SLIME.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return null;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.METAL_SLIME.get());
        list.add((Race)TensuraRaces.DEMON_SLIME.get());
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (!player.f_19853_.m_46469_().m_46207_(TensuraGameRules.HARDCORE_RACE)) {
            return;
        }
        if (player.m_21023_((MobEffect)TensuraMobEffects.PRESENCE_SENSE.get())) {
            return;
        }
        player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.TRUE_BLINDNESS.get(), 40, 0, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40, 0, false, false, false));
    }
}

