/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.vampire;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.vampire.VampireRace;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class GhoulRace
extends Race {
    public GhoulRace() {
        super(Race.Difficulty.HARD);
    }

    public GhoulRace(Race.Difficulty difficulty) {
        super(difficulty);
    }

    @Override
    public double getBaseHealth() {
        return 14.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 3.5;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.08;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)1000.0, (Object)2000.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)2000.0, (Object)3000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.VAMPIRE.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.VAMPIRE_LORD.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.VAMPIRE.get();
    }

    @Override
    public double getAdditionalSpiritualHealth() {
        return 10.0;
    }

    @Override
    public double getSpiritualHealthMultiplier() {
        return 1.0;
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)CommonSkills.PARALYSIS.get()));
        list.add((TensuraSkill)((Object)CommonSkills.STRENGTH.get()));
        list.add((TensuraSkill)((Object)CommonSkills.SELF_REGENERATION.get()));
        return list;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.VAMPIRE.get());
        return list;
    }

    @Override
    public void raceTick(Player player) {
        if (!VampireRace.isUnderSun((LivingEntity)player)) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 4, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 4, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 4, false, false, false));
        if (VampireRace.shouldBurn(player)) {
            player.m_20254_(3);
        }
    }
}

