/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.race.wight;

import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.race.vampire.VampireRace;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.JumpPowerHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class WightRace
extends Race {
    public WightRace() {
        super(Race.Difficulty.HARD);
    }

    @Override
    public double getBaseHealth() {
        return 20.0;
    }

    @Override
    public float getPlayerSize() {
        return 2.0f;
    }

    @Override
    public double getBaseAttackDamage() {
        return 1.0;
    }

    @Override
    public double getBaseAttackSpeed() {
        return 3.8;
    }

    @Override
    public double getKnockbackResistance() {
        return 0.0;
    }

    @Override
    public double getJumpHeight() {
        return JumpPowerHelper.defaultPlayer();
    }

    @Override
    public double getMovementSpeed() {
        return 0.1;
    }

    @Override
    public Pair<Double, Double> getBaseAuraRange() {
        return Pair.of((Object)100.0, (Object)500.0);
    }

    @Override
    public Pair<Double, Double> getBaseMagiculeRange() {
        return Pair.of((Object)2000.0, (Object)3000.0);
    }

    @Override
    @Nullable
    public Race getDefaultEvolution(Player player) {
        return (Race)TensuraRaces.WIGHT_KING.get();
    }

    @Override
    @Nullable
    public Race getAwakeningEvolution(Player player) {
        return (Race)TensuraRaces.SPIRIT_SKELETON.get();
    }

    @Override
    @Nullable
    public Race getHarvestFestivalEvolution(Player player) {
        return (Race)TensuraRaces.WIGHT_KING.get();
    }

    @Override
    public boolean isMajin() {
        return true;
    }

    @Override
    public List<TensuraSkill> getIntrinsicSkills(Player player) {
        ArrayList<TensuraSkill> list = new ArrayList<TensuraSkill>();
        list.add((TensuraSkill)((Object)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get()));
        list.add((TensuraSkill)((Object)ResistanceSkills.PAIN_NULLIFICATION.get()));
        return list;
    }

    @Override
    public List<Race> getNextEvolutions(Player player) {
        ArrayList<Race> list = new ArrayList<Race>();
        list.add((Race)TensuraRaces.WIGHT_KING.get());
        list.add((Race)TensuraRaces.HUMAN.get());
        return list;
    }

    @Override
    public boolean passivelyFriendlyWith(LivingEntity entity) {
        return RaceHelper.isUndead((Entity)entity);
    }

    @Override
    public void raceTick(Player player) {
        if (!VampireRace.isUnderSun((LivingEntity)player)) {
            return;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 40, 2, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40, 2, false, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 40, 2, false, false, false));
        player.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 40, 2, false, false, false));
        if (VampireRace.shouldBurn(player)) {
            player.m_20254_(3);
        }
    }
}

