/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.registry.biome;

import com.github.manasmods.tensura.block.HipokuteGrass;
import com.github.manasmods.tensura.block.SimpleBlock;
import com.github.manasmods.tensura.registry.biome.TensuraFeatures;
import com.github.manasmods.tensura.registry.biome.TensuraPlacedFeatures;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.world.features.FloatingDebrisFeature;
import com.github.manasmods.tensura.world.features.HellBlockBlobFeature;
import com.github.manasmods.tensura.world.features.RockySpikeFeature;
import com.github.manasmods.tensura.world.tree.leaves.PalmFoliagePlacer;
import com.github.manasmods.tensura.world.tree.trunk.PalmTrunkPlacer;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseThresholdProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class TensuraConfiguredFeatures {
    private static final Supplier<List<OreConfiguration.TargetBlockState>> ORE_SILVER_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((SimpleBlock)((Object)((Object)TensuraBlocks.SILVER_ORE.get()))).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((RotatedPillarBlock)TensuraBlocks.DEEPSLATE_SILVER_ORE.get()).m_49966_())));
    private static final Supplier<List<OreConfiguration.TargetBlockState>> ORE_MAGIC_TARGET_LIST = Suppliers.memoize(() -> List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((SimpleBlock)((Object)((Object)TensuraBlocks.MAGIC_ORE.get()))).m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((RotatedPillarBlock)TensuraBlocks.DEEPSLATE_MAGIC_ORE.get()).m_49966_())));
    private static final BeehiveDecorator BEEHIVE = new BeehiveDecorator(0.05f);
    private static final DeferredRegister<ConfiguredFeature<?, ?>> registry = DeferredRegister.create((ResourceKey)Registry.f_122881_, (String)"tensura");
    public static final RegistryObject<ConfiguredFeature<?, ?>> SAKURA_TREE = registry.register("sakura_tree", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)TensuraConfiguredFeatures.basicTree(TensuraBlocks.SAKURA_LOG, TensuraBlocks.SAKURA_LEAVES)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SAKURA_TREE_HIVE = registry.register("sakura_tree_hive", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)TensuraConfiguredFeatures.basicTreeWithHive(TensuraBlocks.SAKURA_LOG, TensuraBlocks.SAKURA_LEAVES)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SAKURA_TREE_LARGE = registry.register("sakura_tree_large", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)TensuraConfiguredFeatures.largeTree(TensuraBlocks.SAKURA_LOG, TensuraBlocks.SAKURA_LEAVES)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SAKURA_TREE_LARGE_HIVE = registry.register("sakura_tree_large_hive", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)TensuraConfiguredFeatures.largeTreeWithHive(TensuraBlocks.SAKURA_LOG, TensuraBlocks.SAKURA_LEAVES)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> SAKURA_FOREST = registry.register("sakura_forest_trees", () -> new ConfiguredFeature(Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)TensuraPlacedFeatures.SAKURA_TREE_LARGE_CHECKED.getHolder().get(), 0.15f)), (Holder)TensuraPlacedFeatures.SAKURA_TREE_CHECKED.getHolder().get())));
    public static final RegistryObject<ConfiguredFeature<?, ?>> PALM_TREE = registry.register("palm_tree", () -> new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TensuraBlocks.PALM_LOG.get())), (TrunkPlacer)new PalmTrunkPlacer(11, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TensuraBlocks.PALM_LEAVES.get())), (FoliagePlacer)new PalmFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68251_()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ORE_SILVER_SMALL = registry.register("ore_silver_small", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_SILVER_TARGET_LIST.get(), 9)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ORE_SILVER_LARGE = registry.register("ore_silver_large", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_SILVER_TARGET_LIST.get(), 12, 0.7f)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ORE_SILVER_BURIED = registry.register("ore_silver_buried", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_SILVER_TARGET_LIST.get(), 9, 0.5f)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ORE_MAGIC = registry.register("ore_magic", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_MAGIC_TARGET_LIST.get(), 4)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ORE_MAGIC_BURIED = registry.register("ore_magic_buried", () -> new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(ORE_MAGIC_TARGET_LIST.get(), 4, 0.5f)));
    public static final RegistryObject<ConfiguredFeature<?, ?>> HIPOKUTE_GRASS = registry.register("hipokute_grass", () -> new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)new RandomPatchConfiguration(40, 3, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new NoiseThresholdProvider(2345L, new NormalNoise.NoiseParameters(0, 1.0, new double[0]), 0.005f, -0.8f, 0.33333334f, ((HipokuteGrass)((Object)((Object)TensuraBlocks.HIPOKUTE_GRASS.get()))).getStateForAge(2), List.of(((HipokuteGrass)((Object)((Object)TensuraBlocks.HIPOKUTE_GRASS.get()))).getStateForAge(3)), List.of(((HipokuteGrass)((Object)((Object)TensuraBlocks.HIPOKUTE_GRASS.get()))).getStateForAge(2), ((HipokuteGrass)((Object)((Object)TensuraBlocks.HIPOKUTE_GRASS.get()))).getStateForAge(1))))))));
    public static final RegistryObject<ConfiguredFeature<?, ?>> ROCKY_SPIKE = registry.register("rocky_spike", () -> new ConfiguredFeature((Feature)((RockySpikeFeature)((Object)((Object)TensuraFeatures.ROCKY_SPIKE.get()))), (FeatureConfiguration)new NoneFeatureConfiguration()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> HELL_BLOCK_BLOB = registry.register("hell_blob_block", () -> new ConfiguredFeature((Feature)((HellBlockBlobFeature)((Object)((Object)TensuraFeatures.HELL_BLOCK_BLOB.get()))), (FeatureConfiguration)new NoneFeatureConfiguration()));
    public static final RegistryObject<ConfiguredFeature<?, ?>> FLOATING_DEBRIS = registry.register("floating_debris", () -> new ConfiguredFeature((Feature)((FloatingDebrisFeature)((Object)((Object)TensuraFeatures.FLOATING_DEBRIS.get()))), (FeatureConfiguration)new NoneFeatureConfiguration()));

    private static TreeConfiguration largeTree(Supplier<? extends Block> logBlock, Supplier<? extends Block> leavesBlock) {
        return TensuraConfiguredFeatures.largeTree(logBlock.get(), leavesBlock.get());
    }

    private static TreeConfiguration largeTree(Block logBlock, Block leavesBlock) {
        return TensuraConfiguredFeatures.largeTree(logBlock, leavesBlock, 3, 11, 0, 4).m_68251_();
    }

    private static TreeConfiguration largeTreeWithHive(Supplier<? extends Block> logBlock, Supplier<? extends Block> leavesBlock) {
        return TensuraConfiguredFeatures.largeTreeWithHive(logBlock.get(), leavesBlock.get());
    }

    private static TreeConfiguration largeTreeWithHive(Block logBlock, Block leavesBlock) {
        return TensuraConfiguredFeatures.largeTree(logBlock, leavesBlock, 3, 11, 0, 4).m_68249_(List.of(BEEHIVE)).m_68251_();
    }

    private static TreeConfiguration basicTree(Supplier<? extends Block> logBlock, Supplier<? extends Block> leavesBlock) {
        return TensuraConfiguredFeatures.basicTree(logBlock.get(), leavesBlock.get());
    }

    private static TreeConfiguration basicTree(Block logBlock, Block leavesBlock) {
        return TensuraConfiguredFeatures.createStraightBlobTree(logBlock, leavesBlock, 4, 2, 0, 2).m_68244_().m_68251_();
    }

    private static TreeConfiguration basicTreeWithHive(Supplier<? extends Block> logBlock, Supplier<? extends Block> leavesBlock) {
        return TensuraConfiguredFeatures.basicTreeWithHive(logBlock.get(), leavesBlock.get());
    }

    private static TreeConfiguration basicTreeWithHive(Block logBlock, Block leavesBlock) {
        return TensuraConfiguredFeatures.createStraightBlobTree(logBlock, leavesBlock, 4, 2, 0, 2).m_68244_().m_68249_(List.of(BEEHIVE)).m_68251_();
    }

    private static TreeConfiguration.TreeConfigurationBuilder createStraightBlobTree(Block logBlock, Block leavesBlock, int baseHeight, int p_195150_, int p_195151_, int leavesRadius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)logBlock), (TrunkPlacer)new StraightTrunkPlacer(baseHeight, p_195150_, p_195151_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leavesBlock), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)leavesRadius), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    private static TreeConfiguration.TreeConfigurationBuilder largeTree(Block logBlock, Block leavesBlock, int baseHeight, int p_195150_, int p_195151_, int leavesRadius) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)logBlock), (TrunkPlacer)new FancyTrunkPlacer(baseHeight, p_195150_, p_195151_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)leavesBlock), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)leavesRadius), (IntProvider)ConstantInt.m_146483_((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).m_68244_();
    }

    public static void init(IEventBus modEventBus) {
        registry.register(modEventBus);
    }
}

