/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.registry.fluids;

import com.github.manasmods.tensura.registry.fluids.TensuraBaseFluidType;
import com.mojang.math.Vector3f;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class TensuraFluidTypes {
    private static final ResourceLocation WATER_SOURCE = new ResourceLocation("block/water_still");
    private static final ResourceLocation WATER_FLOWING = new ResourceLocation("block/water_flow");
    private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"tensura");
    public static final RegistryObject<FluidType> HOT_SPRING_WATER = TensuraFluidTypes.register("hot_spring_water", new Vector3f(0.7529412f, 0.84705883f, 1.0f), -1589389842, FluidType.Properties.create().fallDistanceModifier(0.0f).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).supportsBoating(false).canDrown(true).canExtinguish(true).canHydrate(true).canPushEntity(true).density(3000).viscosity(6000).pathType(BlockPathTypes.WATER).adjacentPathType(null).canSwim(true));

    private static RegistryObject<FluidType> register(String name, Vector3f fogColor, int color, FluidType.Properties properties) {
        return FLUID_TYPES.register(name, () -> new TensuraBaseFluidType(WATER_SOURCE, WATER_FLOWING, WATER_OVERLAY, color, fogColor, properties));
    }

    public static void init(IEventBus modEventBus) {
        FLUID_TYPES.register(modEventBus);
    }
}

