/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.util.damage;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.resist.PhysicalAttackNullification;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.event.SpiritualHurtEvent;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.util.damage.TensuraEntityDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraIndirectEntityDamageSource;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DamageSourceHelper {
    public static float getWeaponDamage(LivingEntity attacker, @Nullable Entity target, boolean offhand) {
        if (offhand) {
            return DamageSourceHelper.getOffWeaponDamage(attacker, target);
        }
        return DamageSourceHelper.getMainWeaponDamage(attacker, target);
    }

    public static float getMainWeaponDamage(LivingEntity attacker, @Nullable Entity target) {
        MobType mobType;
        AttributeInstance attack = attacker.m_21051_(Attributes.f_22281_);
        if (attack == null) {
            return 1.0f;
        }
        float damage = 1.0f;
        AttributeModifier modifier = attack.m_22111_(UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF"));
        if (modifier != null) {
            damage += (float)modifier.m_22218_();
        }
        ItemStack itemStack = attacker.m_21205_();
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            mobType = entity.m_6336_();
        } else {
            mobType = MobType.f_21640_;
        }
        return damage += EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)mobType);
    }

    public static float getWeaponBaseDamage(Item item) {
        float damage = 1.0f;
        if (item instanceof TieredItem) {
            TieredItem tiered = (TieredItem)item;
            damage += tiered.m_43314_().m_6631_();
            if (item instanceof SwordItem) {
                SwordItem sword = (SwordItem)item;
                damage += sword.m_43299_();
            } else if (item instanceof DiggerItem) {
                DiggerItem digger = (DiggerItem)item;
                damage += digger.m_41008_();
            }
        } else if (item instanceof TridentItem) {
            damage += 8.0f;
        }
        return damage;
    }

    public static float getOffWeaponDamage(LivingEntity attacker, @Nullable Entity target) {
        MobType mobType;
        float damage = DamageSourceHelper.getWeaponBaseDamage(attacker.m_21206_().m_41720_());
        ItemStack itemStack = attacker.m_21206_();
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            mobType = entity.m_6336_();
        } else {
            mobType = MobType.f_21640_;
        }
        return damage += EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)mobType);
    }

    public static TensuraDamageSource turnTensura(DamageSource source, @Nullable Entity owner) {
        if (source instanceof IndirectEntityDamageSource) {
            IndirectEntityDamageSource damageSource = (IndirectEntityDamageSource)source;
            return new TensuraIndirectEntityDamageSource(damageSource, owner);
        }
        if (source instanceof EntityDamageSource) {
            EntityDamageSource damageSource = (EntityDamageSource)source;
            return new TensuraEntityDamageSource(damageSource, owner);
        }
        if (source instanceof TensuraDamageSource) {
            TensuraDamageSource tensuraSource = (TensuraDamageSource)source;
            return tensuraSource;
        }
        return new TensuraDamageSource(source);
    }

    public static TensuraDamageSource turnTensura(DamageSource source) {
        return DamageSourceHelper.turnTensura(source, source.m_7639_());
    }

    public static TensuraDamageSource addSkillAndCost(DamageSource source, double amount, ManasSkillInstance skill) {
        return DamageSourceHelper.turnTensura(source).setMpCost(amount).setSkill(skill);
    }

    public static DamageSource addSkillAndCost(DamageSource source, double amount) {
        return DamageSourceHelper.turnTensura(source).setMpCost(amount);
    }

    public static boolean dealSplitDamage(Entity pTarget, DamageSource mainSource, float mainPercentage, DamageSource otherSource, float totalDamage) {
        float mainDamage = totalDamage * mainPercentage;
        boolean success = pTarget.m_6469_(otherSource, totalDamage - mainDamage);
        success = pTarget.m_6469_(mainSource, totalDamage) || success;
        return success;
    }

    public static boolean dealSplitElementalDamage(Entity pTarget, DamageSource source, float mainPercentage, float totalDamage) {
        TensuraDamageSource elementalDamage = DamageSourceHelper.turnTensura(source).setNotTensuraMagic();
        return DamageSourceHelper.dealSplitDamage(pTarget, elementalDamage, mainPercentage, source, totalDamage);
    }

    public static boolean noKnockDamage(DamageSource damageSource) {
        if (!(damageSource instanceof TensuraEntityDamageSource)) {
            return false;
        }
        TensuraEntityDamageSource tensuraSource = (TensuraEntityDamageSource)damageSource;
        return tensuraSource.isNoKnock();
    }

    public static boolean noDyingAnimation(DamageSource damageSource) {
        if (!(damageSource instanceof TensuraEntityDamageSource)) {
            return false;
        }
        TensuraEntityDamageSource tensuraSource = (TensuraEntityDamageSource)damageSource;
        return tensuraSource.isNoDyingAnimation();
    }

    public static void directSpiritualHurt(LivingEntity target, @Nullable Entity attacker, float amount, float resistPercentage) {
        DamageSourceHelper.directSpiritualHurt(target, attacker, null, amount, resistPercentage);
    }

    public static void directSpiritualHurt(LivingEntity target, @Nullable Entity attacker, @Nullable DamageSource damageSource, float amount, float resistPercentage) {
        Player player;
        Level level = target.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        if (!target.m_6084_()) {
            return;
        }
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SPIRITUAL_DAMAGE)) {
            return;
        }
        if (target instanceof Player && (player = (Player)target).m_7500_()) {
            return;
        }
        if (TensuraGameRules.isLabyrinthPvpOff(level, (Entity)target, attacker)) {
            return;
        }
        if (PhysicalAttackNullification.ogreBerserkerResist(damageSource, target)) {
            DamageSource source = damageSource;
            if (source == null) {
                source = attacker != null ? TensuraDamageSources.soulScatter(attacker) : TensuraDamageSources.SOUL_SCATTER;
            }
            target.m_6469_(source, amount);
            return;
        }
        TensuraEPCapability.getFrom(target).ifPresent(cap -> {
            SpiritualHurtEvent event;
            float resisted = amount * (1.0f - resistPercentage);
            DamageSource source = damageSource;
            if (source == null) {
                DamageSource damageSource2 = source = attacker != null ? TensuraDamageSources.soulScatter(attacker) : TensuraDamageSources.SOUL_SCATTER;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)(event = new SpiritualHurtEvent(target, attacker, amount, resistPercentage, resisted, source)))) {
                return;
            }
            for (ManasSkillInstance instance : SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills()) {
                ResistSkill resist;
                ManasSkill patt7637$temp;
                if (instance.getMastery() >= 0 || !((patt7637$temp = instance.getSkill()) instanceof ResistSkill) || !(resist = (ResistSkill)patt7637$temp).getResistType().equals((Object)ResistSkill.ResistType.RESISTANCE) || !resist.isDamageResisted(event.getSource(), instance) || !((double)event.getAmount() > resist.learningCost())) continue;
                resist.addLearnPoint(instance, target);
            }
            cap.setSpiritualHealth(Math.max(cap.getSpiritualHealth() - (double)event.getAmount(), 0.0));
            target.f_19853_.m_6269_(null, (Entity)target, SoundEvents.f_12316_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            DamageSourceHelper.markHurt(target, attacker);
            if (cap.getSpiritualHealth() <= 0.0 && target.m_6084_()) {
                target.m_21231_().m_19289_(event.getSource(), target.m_21223_(), target.m_21223_());
                target.m_21153_(0.0f);
                target.m_7911_(0.0f);
                target.m_6667_(event.getSource().m_19381_());
            }
            TensuraEPCapability.sync(target);
        });
    }

    public static void directSpiritualHurt(LivingEntity target, @Nullable Entity attacker, float amount) {
        DamageSourceHelper.directSpiritualHurt(target, attacker, null, amount);
    }

    public static void directSpiritualHurt(LivingEntity target, @Nullable Entity attacker, @Nullable DamageSource source, float amount) {
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SPIRITUAL_DAMAGE)) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) {
            if (amount <= target.m_21223_() / 2.0f) {
                return;
            }
            DamageSourceHelper.directSpiritualHurt(target, attacker, source, amount, 0.5f);
        } else {
            DamageSourceHelper.directSpiritualHurt(target, attacker, source, amount, 0.0f);
        }
    }

    public static void markHurt(LivingEntity target, @Nullable Entity attacker) {
        Player player;
        if (target instanceof Player && (player = (Player)target).m_7500_()) {
            return;
        }
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (target.f_19802_ < 10) {
                serverLevel.m_7726_().m_8394_((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 1));
            }
        }
        if (attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            if (attacker instanceof Player) {
                Player player2 = (Player)attacker;
                target.m_6598_(player2);
            }
            target.m_6703_(living);
        }
    }

    public static boolean isLightDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("light")) {
            return true;
        }
        if (damageSource.m_19385_().contains("heaven")) {
            return true;
        }
        if (damageSource.m_19385_().contains("sun")) {
            return true;
        }
        if (damageSource.m_19385_().contains("wisp")) {
            return true;
        }
        return damageSource.m_19385_().contains("paradise");
    }

    public static boolean isDarkDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("dark")) {
            return true;
        }
        if (damageSource.m_19385_().contains("hell")) {
            return true;
        }
        if (damageSource.m_19385_().contains("abyss")) {
            return true;
        }
        if (damageSource.m_19385_().contains("ray_of_siphoning")) {
            return true;
        }
        return damageSource.m_19385_().contains("void");
    }

    public static boolean isEarthDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("earth")) {
            return true;
        }
        if (damageSource.m_19385_().contains("stone")) {
            return true;
        }
        if (damageSource.m_19385_().contains("rock")) {
            return true;
        }
        if (damageSource.m_19385_().contains("dirt")) {
            return true;
        }
        if (damageSource.m_19385_().contains("magma")) {
            return true;
        }
        return damageSource.equals(DamageSource.f_19310_);
    }

    public static boolean isFireDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("flame")) {
            return true;
        }
        if (damageSource.m_19385_().contains("flaming")) {
            return true;
        }
        if (damageSource.m_19385_().contains("scorch")) {
            return true;
        }
        if (damageSource.m_19385_().contains("burn")) {
            return true;
        }
        if (damageSource.m_19385_().contains("blaze")) {
            return true;
        }
        if (damageSource.m_19385_().contains("Fire")) {
            return true;
        }
        return damageSource.m_19385_().contains("fire");
    }

    public static boolean isGravityDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("blackHole")) {
            return true;
        }
        if (damageSource.m_19385_().contains("black_hole")) {
            return true;
        }
        if (damageSource.m_19385_().contains("oppress")) {
            return true;
        }
        if (damageSource.m_19385_().contains("star")) {
            return true;
        }
        return damageSource.m_19385_().contains("gravity");
    }

    public static boolean isLightningDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("lightning")) {
            return true;
        }
        if (damageSource.m_19385_().contains("thunder")) {
            return true;
        }
        if (damageSource.m_19385_().contains("electric")) {
            return true;
        }
        if (damageSource.m_19385_().contains("electrocute")) {
            return true;
        }
        if (damageSource.m_19385_().contains("bolt") && !damageSource.m_19385_().contains("fire")) {
            return true;
        }
        return damageSource.equals(DamageSource.f_19306_);
    }

    public static boolean isSoundDamage(DamageSource damageSource) {
        if (damageSource.m_19385_().contains("tensura.mind_requiem")) {
            return true;
        }
        if (damageSource.m_19385_().contains("music")) {
            return true;
        }
        if (damageSource.m_19385_().contains("sound")) {
            return true;
        }
        if (damageSource.m_19385_().contains("shockwave")) {
            return true;
        }
        if (damageSource.m_19385_().contains("echo")) {
            return true;
        }
        return damageSource.m_19385_().contains("sonic");
    }

    public static boolean isWaterDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("water")) {
            return true;
        }
        if (damageSource.m_19385_().contains("icicle")) {
            return true;
        }
        if (damageSource.m_19385_().contains("ice")) {
            return true;
        }
        return damageSource.equals(DamageSource.f_19312_);
    }

    public static boolean isWindDamage(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("wind")) {
            return true;
        }
        if (damageSource.m_19385_().contains("gust")) {
            return true;
        }
        return damageSource.m_19385_().contains("tornado");
    }

    public static boolean isSpatialDamage(DamageSource damageSource) {
        TensuraDamageSource source;
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)damageSource).isSpatial()) {
            return true;
        }
        if (damageSource.m_19385_().contains("sever")) {
            return true;
        }
        if (damageSource.m_19385_().contains("dimension")) {
            return true;
        }
        if (damageSource.m_19385_().contains("space")) {
            return true;
        }
        if (damageSource.m_19385_().contains("ender")) {
            return true;
        }
        if (damageSource.m_19385_().contains("dragon_breath")) {
            return true;
        }
        return damageSource.m_19385_().contains("spatial");
    }

    public static boolean isAbnormal(DamageSource damageSource) {
        if (damageSource.m_19385_().contains("petrification")) {
            return true;
        }
        if (damageSource.m_19385_().contains("petrificate")) {
            return true;
        }
        if (damageSource.m_19385_().contains("insane")) {
            return true;
        }
        if (damageSource.m_19385_().contains("insanity")) {
            return true;
        }
        if (damageSource.m_19385_().contains("virus")) {
            return true;
        }
        if (damageSource.m_19385_().contains("infection")) {
            return true;
        }
        if (damageSource.m_19385_().contains("fear")) {
            return true;
        }
        return damageSource.m_19385_().contains("scare");
    }

    public static boolean isCorrosion(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("corrosion")) {
            return true;
        }
        if (damageSource.m_19385_().contains("wither")) {
            return true;
        }
        return damageSource.equals(DamageSource.f_19320_);
    }

    public static boolean isCold(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19385_().contains("cold")) {
            return true;
        }
        if (damageSource.m_19385_().contains("ice")) {
            return true;
        }
        if (damageSource.m_19385_().contains("frost")) {
            return true;
        }
        if (damageSource.m_19385_().contains("freeze")) {
            return true;
        }
        if (damageSource.m_19385_().contains("snow")) {
            return true;
        }
        return damageSource.equals(DamageSource.f_146701_);
    }

    public static boolean isHeat(DamageSource damageSource) {
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        if (damageSource.m_19372_()) {
            return true;
        }
        if (DamageSourceHelper.isFireDamage(damageSource)) {
            return true;
        }
        if (damageSource.m_19385_().contains("hot")) {
            return true;
        }
        if (damageSource.m_19385_().contains("warm")) {
            return true;
        }
        if (damageSource.m_19385_().contains("heat")) {
            return true;
        }
        if (damageSource.m_19385_().contains("hyperthermia")) {
            return true;
        }
        if (damageSource.m_19385_().contains("megiddo")) {
            return true;
        }
        return damageSource.equals(DamageSource.f_19308_);
    }

    public static boolean isHoly(DamageSource damageSource) {
        TensuraDamageSource tensuraSource;
        if (damageSource instanceof TensuraDamageSource && (tensuraSource = (TensuraDamageSource)damageSource).isHoly()) {
            return true;
        }
        if (damageSource.m_19385_().contains("holy")) {
            return true;
        }
        if (damageSource.m_19385_().contains("divine")) {
            return true;
        }
        return damageSource.equals(TensuraDamageSources.HOLY_DAMAGE);
    }

    public static boolean isPoison(DamageSource damageSource) {
        if (damageSource.equals(TensuraDamageSources.MAGICULE_POISON)) {
            return false;
        }
        if (damageSource.m_19385_().contains("poison")) {
            return true;
        }
        if (damageSource.m_19385_().contains("venom")) {
            return true;
        }
        if (damageSource.m_19385_().contains("toxic")) {
            return true;
        }
        return damageSource.m_19385_().contains("toxin");
    }

    public static boolean isTensuraMagic(DamageSource damageSource) {
        if (!damageSource.m_19387_()) {
            return false;
        }
        if (!(damageSource instanceof TensuraDamageSource)) {
            return true;
        }
        TensuraDamageSource source = (TensuraDamageSource)damageSource;
        return !source.isNotTensuraMagic() || damageSource.m_19385_().contains("magic");
    }

    public static boolean isNaturalEffects(DamageSource damageSource) {
        if (DamageSourceHelper.isDarkDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isLightDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isEarthDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isFireDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isWaterDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isWindDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isSpatialDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isLightningDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isGravityDamage(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isHeat(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isCold(damageSource)) {
            return true;
        }
        return DamageSourceHelper.isCorrosion(damageSource);
    }

    public static boolean isPhysicalAttack(DamageSource damageSource) {
        EntityDamageSource source;
        if (damageSource.m_19378_()) {
            return false;
        }
        if (damageSource.m_19384_()) {
            return false;
        }
        if (damageSource.m_19372_()) {
            return false;
        }
        if (damageSource instanceof EntityDamageSource && (source = (EntityDamageSource)damageSource).m_19403_()) {
            return false;
        }
        if (DamageSourceHelper.isTensuraMagic(damageSource)) {
            return false;
        }
        return !damageSource.m_19387_();
    }

    public static boolean isPierce(DamageSource damageSource) {
        Entity entity = damageSource.m_7640_();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (projectile.m_6095_().m_20675_().contains("arrow")) {
                return true;
            }
            if (projectile.m_6095_().m_20675_().contains("spear")) {
                return true;
            }
            if (projectile.m_6095_().m_20675_().contains("kunai")) {
                return true;
            }
            if (projectile.m_6095_().m_20675_().contains("trident")) {
                return true;
            }
            return projectile.m_6095_().m_20675_().contains("horn");
        }
        entity = damageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.m_21120_(InteractionHand.MAIN_HAND).m_41720_().m_5524_().contains("spear")) {
                return true;
            }
            return living.m_21120_(InteractionHand.MAIN_HAND).m_41720_().m_5524_().contains("trident");
        }
        return false;
    }

    public static boolean isSpiritual(DamageSource damageSource) {
        if (damageSource.m_19385_().contains("soul")) {
            return true;
        }
        return damageSource.m_19385_().contains("spirit");
    }

    public static boolean isTemperature(DamageSource damageSource) {
        if (DamageSourceHelper.isCold(damageSource)) {
            return true;
        }
        if (DamageSourceHelper.isHeat(damageSource)) {
            return true;
        }
        if (damageSource.m_19385_().contains("thermal")) {
            return true;
        }
        if (damageSource.m_19385_().contains("thermia")) {
            return true;
        }
        return damageSource.m_19385_().contains("temperature");
    }
}

