/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.util.damage;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.entity.magic.misc.TempestScaleEntity;
import com.github.manasmods.tensura.entity.projectile.KunaiProjectile;
import com.github.manasmods.tensura.entity.projectile.SevererBladeProjectile;
import com.github.manasmods.tensura.entity.projectile.SpearProjectile;
import com.github.manasmods.tensura.entity.projectile.UnicornHornProjectile;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraEntityDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraIndirectEntityDamageSource;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;

public class TensuraDamageSources {
    public static final String DARK_ATTACK = "tensura.dark_attack";
    public static final String EARTH_ATTACK = "tensura.earth_attack";
    public static final String FIRE_ATTACK = "tensura.fire_attack";
    public static final String GRAVITY_ATTACK = "tensura.gravity_attack";
    public static final String LIGHT_ATTACK = "tensura.light_attack";
    public static final String LIGHTNING_ATTACK = "tensura.lightning_attack";
    public static final String SPACE_ATTACK = "tensura.space_attack";
    public static final String WATER_ATTACK = "tensura.water_attack";
    public static final String WIND_ATTACK = "tensura.wind_attack";
    public static final DamageSource CORROSION = new TensuraDamageSource("tensura.corrosion").setNotTensuraMagic().m_19380_().m_238403_().m_19389_();
    public static final DamageSource CURSE = new TensuraDamageSource("tensura.curse").setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_238403_().m_19389_().m_19382_();
    public static final DamageSource FATAL_POISON = new TensuraDamageSource("tensura.fatal_poison").setNotTensuraMagic().m_19380_().m_19389_().m_19382_();
    public static final DamageSource FEAR = new TensuraDamageSource("tensura.fear").setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19389_().m_19380_().m_19382_().m_238403_();
    public static final DamageSource HOLY_DAMAGE = new TensuraDamageSource("tensura.holy_damage").setNotTensuraMagic().setHoly().m_19380_().m_19389_();
    public static final DamageSource INFECTION = new TensuraDamageSource("tensura.infection").setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_19389_().m_19382_();
    public static final DamageSource INSANITY = new TensuraDamageSource("tensura.insanity").setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_238403_().m_19389_();
    public static final DamageSource MAGICULE_POISON = new TensuraDamageSource("tensura.magicule_poison").setIgnoreBarrier(2.0f).setNotTensuraMagic().m_19389_().m_19380_().m_238403_().m_19382_();
    public static final DamageSource PETRIFICATION = new TensuraDamageSource("tensura.petrification").setNotTensuraMagic().setIgnoreBarrier(1.0f).m_19380_().m_19389_().m_19382_();
    public static final DamageSource STEEL_THREAD = new TensuraDamageSource("tensura.steelThread");
    public static final DamageSource SOUL_SCATTER = new TensuraDamageSource("tensura.soul_scatter").setIgnoreBarrier(2.0f).setNotTensuraMagic().m_19389_().m_19382_().m_238403_().m_19380_().m_19381_();
    public static final DamageSource SUFFOCATE = new TensuraDamageSource("tensura.suffocate").m_19382_().m_238403_().m_19380_().m_19381_();
    public static final DamageSource BLACK_FLAME = new TensuraDamageSource("tensura.black_flame").m_19383_().m_238403_().m_19389_();
    public static final DamageSource BLACK_LIGHTNING = new TensuraDamageSource("tensura.black_lightning").m_238403_().m_19389_();
    public static final DamageSource BLOOD_DRAIN = new TensuraDamageSource("tensura.blood_drain").setNoKnock().setNotTensuraMagic().m_19380_().m_238403_().m_19389_();
    public static final DamageSource DEATH_TORNADO = new TensuraDamageSource("tensura.death_tornado").m_238403_().m_19389_();
    public static final DamageSource DROWSY_DEATH = new TensuraDamageSource("tensura.drowsy_death").setNotTensuraMagic().setIgnoreBarrier(1.75f).m_19380_().m_238403_().m_19389_().m_19382_();
    public static final DamageSource HEAT_WAVE = new TensuraDamageSource("tensura.heat_wave").setNotTensuraMagic().m_19383_().m_19380_().m_19389_();
    public static final DamageSource DEVOURED = new TensuraDamageSource("tensura.devoured").setNoDyingAnimation().setNotTensuraMagic().setIgnoreBarrier(1.5f).m_19380_().m_238403_().m_19389_();
    public static final DamageSource SOUL_CONSUMED = new TensuraDamageSource("tensura.soul_consumed").setNotTensuraMagic().setIgnoreBarrier(1.0f).m_19389_().m_19382_().m_238403_().m_19380_();
    public static final DamageSource SEVERANCE_UPDATE = new TensuraDamageSource("tensura.severance_update").setNotTensuraMagic().setIgnoreBarrier(2.0f).m_19389_().m_19382_().m_238403_().m_19380_().m_19381_();
    public static final DamageSource OUT_OF_ENERGY = new TensuraDamageSource("tensura.out_of_energy").setNotTensuraMagic().setIgnoreBarrier(2.0f).m_19389_().m_19382_().m_238403_().m_19380_().m_19381_();

    public static DamageSource indirectElementalAttack(String elemental, Entity pSource, @Nullable Entity indirectSource, double mp, @Nullable ManasSkillInstance skill, boolean isSpirit) {
        TensuraDamageSource source = new TensuraIndirectEntityDamageSource(elemental, pSource, indirectSource).setMpCost(mp).setSkill(skill).setNotTensuraMagic().setNoKnock();
        if (isSpirit) {
            return source.setNotTensuraMagic().m_19389_();
        }
        return source.m_19389_();
    }

    public static DamageSource indirectElementalAttack(String elemental, Entity pSource, @Nullable Entity indirectSource, boolean isSpirit) {
        return TensuraDamageSources.indirectElementalAttack(elemental, pSource, indirectSource, 0.0, null, isSpirit);
    }

    public static DamageSource elementalAttack(String elemental, Entity pSource, double mp, @Nullable ManasSkillInstance skill, boolean isSpirit) {
        TensuraDamageSource source = new TensuraEntityDamageSource(elemental, pSource).setMpCost(mp).setSkill(skill).setNoKnock();
        if (isSpirit) {
            return source.setNotTensuraMagic().m_19389_();
        }
        return source.m_19389_();
    }

    public static DamageSource elementalAttack(String elemental, Entity pSource, boolean isSpirit) {
        return TensuraDamageSources.elementalAttack(elemental, pSource, 0.0, null, isSpirit);
    }

    public static DamageSource corrosion(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.corrosion", pSource).setNoKnock().setNotTensuraMagic().m_19380_().m_238403_().m_19389_();
    }

    public static DamageSource fatalPoison(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.fatal_poison", pSource).setNoKnock().setNotTensuraMagic().m_19380_().m_19389_().m_19382_();
    }

    public static DamageSource fear(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.fear", pSource).setNoKnock().setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_19389_().m_19382_().m_238403_().m_181120_();
    }

    public static DamageSource holyDamage(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.holy_damage", pSource).setNotTensuraMagic().m_19380_().m_19389_();
    }

    public static DamageSource holyDamage(Entity pSource, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.holy_damage", pSource, pIndirectEntity).setNotTensuraMagic().m_19380_().m_19389_();
    }

    public static DamageSource infection(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.infection", pSource).setNoKnock().setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_19389_().m_19382_().m_181120_();
    }

    public static DamageSource insanity(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.insanity", pSource).setNoKnock().setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_238403_().m_19389_().m_181120_();
    }

    public static DamageSource genericMagic(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.generic_magic", pSource).m_19380_().m_19389_();
    }

    public static DamageSource petrification(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.petrification", pSource).setNoKnock().setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19380_().m_19389_().m_19382_();
    }

    public static DamageSource soulScatter(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.soul_scatter", pSource).setIgnoreBarrier(1.0f).setNotTensuraMagic().m_19389_().m_19382_().m_238403_().m_19380_().m_19381_();
    }

    public static DamageSource kunai(KunaiProjectile kunai, @Nullable Entity pIndirectEntity) {
        return new IndirectEntityDamageSource("tensura.kunai", (Entity)kunai, pIndirectEntity).m_19366_();
    }

    public static DamageSource spear(SpearProjectile spear, @Nullable Entity pIndirectEntity) {
        return new IndirectEntityDamageSource("tensura.spear", (Entity)spear, pIndirectEntity).m_19366_();
    }

    public static DamageSource severerBlade(SevererBladeProjectile blade, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.severer_blade", (Entity)blade, pIndirectEntity).setNotTensuraMagic().m_19366_().m_19389_();
    }

    public static DamageSource shot(Projectile projectile, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.shot", (Entity)projectile, pIndirectEntity).m_19366_();
    }

    public static DamageSource tempestScale(TempestScaleEntity scale, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.tempest_scale", (Entity)scale, pIndirectEntity).m_19366_().m_19380_();
    }

    public static DamageSource unicornHorn(UnicornHornProjectile projectile, @Nullable Entity pIndirectEntity) {
        return new IndirectEntityDamageSource("tensura.unicorn_horn", (Entity)projectile, pIndirectEntity).m_19366_().m_19380_().m_19375_();
    }

    public static DamageSource auraBullet(TensuraProjectile bullet, @Nullable Entity pIndirectEntity, ManasSkillInstance art, double cost) {
        return new TensuraIndirectEntityDamageSource("tensura.aura_bullet", (Entity)bullet, pIndirectEntity).setNoKnock().setSkill(art).setApCost(cost).m_19366_();
    }

    public static DamageSource auraSlash(TensuraProjectile bullet, @Nullable Entity pIndirectEntity, ManasSkillInstance art, double cost) {
        return new TensuraIndirectEntityDamageSource("tensura.aura_slash", (Entity)bullet, pIndirectEntity).setNoKnock().setSkill(art).setApCost(cost).m_19366_();
    }

    public static DamageSource blackFlame(Entity entity) {
        return new TensuraEntityDamageSource("tensura.black_flame", entity).setNoKnock().m_238403_().m_19383_().m_19389_();
    }

    public static DamageSource blackLightning(Entity entity) {
        return new TensuraEntityDamageSource("tensura.black_lightning", entity).setNoKnock().m_238403_().m_19389_();
    }

    public static DamageSource bloodDrain(Entity entity) {
        return new TensuraEntityDamageSource("tensura.blood_drain", entity).setNoKnock().setNotTensuraMagic().m_19380_().m_238403_().m_19389_();
    }

    public static DamageSource bloodRay(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.blood_ray", pSource).setNoKnock().m_19380_().m_19389_().m_238403_();
    }

    public static DamageSource burn(Entity entity) {
        return new TensuraEntityDamageSource("tensura.burn", entity).setNoKnock().setNotTensuraMagic().m_19380_().m_19383_().m_19389_();
    }

    public static DamageSource deathTornado(Entity entity) {
        return new TensuraEntityDamageSource("tensura.death_tornado", entity).setNoKnock().m_238403_().m_19389_();
    }

    public static DamageSource devour(Entity entity) {
        return new TensuraEntityDamageSource("tensura.devoured", entity).setNoDyingAnimation().setNotTensuraMagic().setIgnoreBarrier(1.5f).m_19380_().m_238403_().m_19389_();
    }

    public static DamageSource dimensionRay(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.dimension_ray", pSource).setNoKnock().setSpatial().setNotTensuraMagic().m_19380_().m_19389_().m_238403_();
    }

    public static DamageSource drowsyDeath(Entity pSource) {
        return new TensuraEntityDamageSource("tensura.drowsy_death", pSource).setNoKnock().setIgnoreBarrier(1.75f).setNotTensuraMagic().m_19380_().m_19389_().m_19382_();
    }

    public static DamageSource flameBreath(BreathEntity breath, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.flame_breath", (Entity)breath, pIndirectEntity).setNoKnock().setNotTensuraMagic().m_19383_().m_19389_();
    }

    public static DamageSource reflectorEcho(TensuraProjectile projectile, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.reflector_echo", (Entity)projectile, pIndirectEntity).setNoKnock().m_19389_();
    }

    public static DamageSource heatWave(Entity entity) {
        return new TensuraEntityDamageSource("tensura.heat_wave", entity).setNoKnock().setNotTensuraMagic().m_19380_().m_19383_().m_19389_();
    }

    public static DamageSource lightning(Entity entity) {
        return new TensuraEntityDamageSource("tensura.lightning", entity).setNoKnock().m_238403_().m_19389_();
    }

    public static DamageSource poisonousBreath(BreathEntity breath, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.poisonous_breath", (Entity)breath, pIndirectEntity).setNoKnock().setNotTensuraMagic().m_19389_();
    }

    public static DamageSource oppression(Entity source) {
        return new TensuraEntityDamageSource("tensura.oppression", source).setNoKnock().setNotTensuraMagic().m_19380_().m_19389_();
    }

    public static DamageSource oppressionBleve(Entity source) {
        return new TensuraEntityDamageSource("tensura.oppression_bleve", source).setIgnoreBarrier(1.0f).setNoKnock().setNotTensuraMagic().m_19380_().m_19389_().m_19375_();
    }

    public static DamageSource mindRequiem(Entity source) {
        return new TensuraEntityDamageSource("tensura.mind_requiem", source).setNotTensuraMagic().m_19380_().m_19389_();
    }

    public static DamageSource megiddo(Entity entity) {
        return new TensuraEntityDamageSource("tensura.megiddo", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.0f).m_19380_().m_238403_().m_19389_();
    }

    public static DamageSource severanceBlade(TensuraProjectile blade, Entity source) {
        return new TensuraIndirectEntityDamageSource("tensura.severance_blade", (Entity)blade, source).setSpatial().setNotTensuraMagic().m_19389_();
    }

    public static DamageSource sonicBlast(Entity source) {
        return new TensuraEntityDamageSource("tensura.sonic_blast", source).setNoKnock().setNotTensuraMagic().m_19380_().m_19389_();
    }

    public static DamageSource thunderBreath(BreathEntity breath, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.thunder_breath", (Entity)breath, pIndirectEntity).setNoKnock().setNotTensuraMagic().m_19389_();
    }

    public static DamageSource waterBlade(TensuraProjectile waterBlade, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.water_blade", (Entity)waterBlade, pIndirectEntity).setNoKnock().m_19366_();
    }

    public static DamageSource waterBreath(BreathEntity breath, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.water_breath", (Entity)breath, pIndirectEntity).setNoKnock().setNotTensuraMagic().m_19389_();
    }

    public static DamageSource wickedLightRay(Entity entity) {
        return new TensuraEntityDamageSource("tensura.wicked_light_ray", entity).m_19389_().m_19380_().m_238403_().m_19382_();
    }

    public static DamageSource windBreath(BreathEntity breath, @Nullable Entity pIndirectEntity) {
        return new TensuraIndirectEntityDamageSource("tensura.wind_breath", (Entity)breath, pIndirectEntity).setNoKnock().setNotTensuraMagic().m_19389_();
    }

    public static TensuraDamageSource steelThread(Entity entity) {
        return new TensuraEntityDamageSource("tensura.steel_thread", entity).setNoKnock();
    }

    public static DamageSource deathBless(Entity entity) {
        return new TensuraEntityDamageSource("tensura.death_bless", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.5f).m_19389_().m_19382_().m_238403_().m_19380_();
    }

    public static DamageSource deathWish(Entity entity) {
        return new TensuraEntityDamageSource("tensura.death_wish", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.75f).m_19389_().m_19382_().m_238403_().m_19380_();
    }

    public static DamageSource drainEP(Entity entity) {
        return new TensuraEntityDamageSource("tensura.drain_EP", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.5f).m_19389_().m_19382_().m_238403_().m_19380_();
    }

    public static DamageSource heartEat(Entity entity) {
        return new TensuraEntityDamageSource("tensura.heart_eaten", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.75f).m_19389_().m_19382_().m_238403_().m_19380_();
    }

    public static DamageSource infiniteEater(Entity entity) {
        return new TensuraEntityDamageSource("tensura.infinite_eater", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.75f).m_19389_().m_19382_().m_238403_().m_19380_();
    }

    public static DamageSource selfKill(Entity source) {
        return new TensuraEntityDamageSource("tensura.self_kill", source).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.5f).m_19389_().m_19380_().m_238403_().m_19382_();
    }

    public static DamageSource soulConsume(Entity entity) {
        return new TensuraEntityDamageSource("tensura.soul_consumed", entity).setNoKnock().setNotTensuraMagic().setIgnoreBarrier(1.75f).m_181120_().m_19389_().m_19382_().m_238403_().m_19380_();
    }

    public static DamageSource synthesise(Entity entity) {
        return new TensuraEntityDamageSource("tensura.synthesise", entity).setNoKnock().setIgnoreBarrier(2.0f).m_19382_().m_238403_().m_19380_().m_19381_();
    }

    public static DamageSource noEnergySource(Entity entity) {
        return new TensuraEntityDamageSource("tensura.no_energy_source", entity).setNotTensuraMagic().setIgnoreBarrier(2.0f).m_19389_().m_19382_().m_238403_().m_19380_().m_19382_();
    }
}

