/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.world.structure;

import com.github.manasmods.tensura.registry.structure.TensuraStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class JigsawMinHeightStructure
extends Structure {
    public static final Codec<JigsawMinHeightStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)JigsawMinHeightStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.fieldOf("minY").orElse((Object)0).forGetter(structure -> structure.minY)).apply((Applicative)instance, JigsawMinHeightStructure::new)).flatXmap(JigsawMinHeightStructure.verifyRange(), JigsawMinHeightStructure.verifyRange()).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final boolean useExpansionHack;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final int minY;

    private static Function<JigsawMinHeightStructure, DataResult<JigsawMinHeightStructure>> verifyRange() {
        return structure -> {
            int i = switch (structure.m_226620_()) {
                default -> throw new IncompatibleClassChangeError();
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            };
            return structure.maxDistanceFromCenter + i > 256 ? DataResult.error((String)"Structure size including terrain adaptation must not exceed 256") : DataResult.success((Object)structure);
        };
    }

    public JigsawMinHeightStructure(Structure.StructureSettings settings, Holder<StructureTemplatePool> holder, Optional<ResourceLocation> location, int depth, HeightProvider height, boolean hack, Optional<Heightmap.Types> project, int distance, int minY) {
        super(settings);
        this.startPool = holder;
        this.startJigsawName = location;
        this.maxDepth = depth;
        this.startHeight = height;
        this.useExpansionHack = hack;
        this.projectStartToHeightmap = project;
        this.maxDistanceFromCenter = distance;
        this.minY = minY;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), i, chunkpos.m_45605_());
        if (this.projectStartToHeightmap.isPresent()) {
            int y = context.f_226622_().m_223221_(blockpos.m_123341_(), blockpos.m_123343_(), switch (this.projectStartToHeightmap.get()) {
                case Heightmap.Types.WORLD_SURFACE_WG -> Heightmap.Types.WORLD_SURFACE;
                case Heightmap.Types.OCEAN_FLOOR_WG -> Heightmap.Types.OCEAN_FLOOR;
                default -> this.projectStartToHeightmap.get();
            }, context.f_226629_(), context.f_226624_());
            if (y < this.minY) {
                return Optional.empty();
            }
        }
        Pools.m_236490_();
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)blockpos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TensuraStructureTypes.JIGSAW_MIN_HEIGHT.get();
    }
}

