/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.data;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.data.MatterValueDataProvider;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapelessRecipeBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ReplicationRecipesProvider
extends RecipeProvider {
    private final Supplier<List<Block>> blocksToProcess;
    private CompletableFuture<HolderLookup.Provider> registries;

    public ReplicationRecipesProvider(DataGenerator generatorIn, Supplier<List<Block>> blocksToProcess, CompletableFuture<HolderLookup.Provider> registries) {
        super(generatorIn.getPackOutput(), registries);
        this.blocksToProcess = blocksToProcess;
        this.registries = registries;
    }

    public void buildRecipes(RecipeOutput consumer) {
        for (Block block : this.blocksToProcess.get()) {
            if (!(block instanceof BasicTileBlock)) continue;
            BasicTileBlock rotatableBlock = (BasicTileBlock)block;
            rotatableBlock.registerRecipe(consumer);
        }
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ReplicationRegistry.Items.MEMORY_CHIP.get())).pattern(" RI").pattern("RIG").pattern("IG ").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('I'), (ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()).define(Character.valueOf('G'), (ItemLike)Items.GOLD_INGOT).save(consumer);
        TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)ReplicationRegistry.Blocks.RAW_REPLICA_BLOCK.get())).requires((ItemLike)ReplicationRegistry.Items.RAW_REPLICA.get(), 9).save(consumer);
        TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)ReplicationRegistry.Items.RAW_REPLICA.get()), (int)9).requires((ItemLike)ReplicationRegistry.Blocks.RAW_REPLICA_BLOCK.get(), 1).save(consumer);
        TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)ReplicationRegistry.Blocks.REPLICA_BLOCK.get())).requires((ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get(), 9).save(consumer);
        TitaniumShapelessRecipeBuilder.shapelessRecipe((ItemLike)((ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()), (int)9).requires((ItemLike)ReplicationRegistry.Blocks.REPLICA_BLOCK.get(), 1).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReplicationRegistry.Items.RAW_REPLICA.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()), (float)0.35f, (int)200).unlockedBy("has_plastic", ReplicationRecipesProvider.has((ItemLike)((ItemLike)ReplicationRegistry.Items.RAW_REPLICA.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"smelting_raw_replica"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ReplicationRegistry.Items.RAW_REPLICA.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()), (float)0.35f, (int)100).unlockedBy("has_plastic", ReplicationRecipesProvider.has((ItemLike)((ItemLike)ReplicationRegistry.Items.RAW_REPLICA.get()))).save(consumer, ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"blasting_raw_replica"));
        new MatterValueDataProvider().buildRecipes(consumer);
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)((ItemLike)ReplicationRegistry.Items.REPLICATOR_ENCLOSURE.get())).pattern("GGG").pattern("GRG").pattern("GGG").define(Character.valueOf('R'), (ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()).define(Character.valueOf('G'), (ItemLike)Items.PURPLE_STAINED_GLASS_PANE).save(consumer);
        ItemStack motorTemplate = new ItemStack(ReplicationRegistry.Items.MATTER_BLUEPRINT);
        CompoundTag tag = new CompoundTag();
        try {
            tag.put("Item", new ItemStack(ReplicationRegistry.Items.REPLICATOR_MOTOR).saveOptional(this.registries.get()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        tag.putDouble("Progress", 1.0);
        motorTemplate.set(ReplicationAttachments.BLUEPRINT, (Object)tag);
        ShapedRecipeBuilder shaped = new ShapedRecipeBuilder(RecipeCategory.MISC, motorTemplate);
        shaped.unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()}).build()}));
        shaped.pattern("RBR").pattern("RPR").pattern("RMR").define(Character.valueOf('R'), (ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()).define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('B'), (ItemLike)Items.BLAZE_POWDER).define(Character.valueOf('M'), (ItemLike)Items.PISTON).save(consumer);
    }
}

