/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.integration.kubejs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class ReplicationKubeJSGateway {
    private static ResourceLocation resolveMatterKey(String key) {
        if (key.indexOf(58) < 0) {
            return ResourceLocation.fromNamespaceAndPath((String)"replication", (String)key);
        }
        return ResourceLocation.parse((String)key);
    }

    public Map<String, Object> matterValueForItem(String itemId, Map<String, Object> matterMap) {
        Map<String, Object> ingredient = Map.of("item", itemId);
        return this.buildMatterValueJson(ingredient, matterMap);
    }

    public Map<String, Object> matterValueForTag(String tag, Map<String, Object> matterMap) {
        String t = tag.startsWith("#") ? tag.substring(1) : tag;
        Map<String, Object> ingredient = Map.of("tag", t);
        return this.buildMatterValueJson(ingredient, matterMap);
    }

    public Map<String, Object> matterValue(Map<String, Object> ingredient, Map<String, Object> matterMap) {
        return this.buildMatterValueJson(ingredient, matterMap);
    }

    private Map<String, Object> buildMatterValueJson(Map<String, Object> ingredient, Map<String, Object> matterMap) {
        ArrayList matterList = new ArrayList();
        for (Map.Entry<String, Object> e : matterMap.entrySet()) {
            double amount;
            Object v = e.getValue();
            if (v instanceof Number) {
                Number n = (Number)v;
                amount = n.doubleValue();
            } else if (v instanceof String) {
                String s = (String)v;
                amount = Double.parseDouble(s);
            } else {
                throw new IllegalArgumentException("Invalid amount for matter '" + e.getKey() + "': " + String.valueOf(v));
            }
            HashMap<String, Object> mv = new HashMap<String, Object>();
            mv.put("type", ReplicationKubeJSGateway.resolveMatterKey(e.getKey()).toString());
            mv.put("amount", amount);
            matterList.add(mv);
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("type", "replication:matter_value");
        json.put("input", ingredient);
        json.put("matter", matterList);
        return json;
    }
}

