/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.packet;

import com.buuz135.replication.client.gui.ReplicationTerminalScreen;
import com.buuz135.replication.network.MatterNetwork;
import com.buuz135.replication.packet.TaskSyncPacket;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.network.Message;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class TaskCancelPacket
extends Message {
    public String task;
    public String network;

    public TaskCancelPacket(String task, String network) {
        this.task = task;
        this.network = network;
    }

    public TaskCancelPacket() {
    }

    protected void handleMessage(IPayloadContext context) {
        context.enqueueWork(() -> {
            for (Network network : NetworkManager.get((Level)context.player().level()).getNetworks()) {
                if (!network.getId().equals(this.network) || !(network instanceof MatterNetwork)) continue;
                MatterNetwork matterNetwork = (MatterNetwork)network;
                matterNetwork.cancelTask(this.task, context.player().level());
                break;
            }
        });
    }

    public static class Response
    extends Message {
        public String task;
        public String network;

        public Response(String task, String network) {
            this.task = task;
            this.network = network;
        }

        public Response() {
        }

        protected void handleMessage(IPayloadContext context) {
            context.enqueueWork(() -> {
                ((HashMap)TaskSyncPacket.CLIENT_TASK_STORAGE.getOrDefault(this.network, new LinkedHashMap())).remove(this.task);
                Screen patt0$temp = Minecraft.getInstance().screen;
                if (patt0$temp instanceof ReplicationTerminalScreen) {
                    ReplicationTerminalScreen terminalScreen = (ReplicationTerminalScreen)patt0$temp;
                    terminalScreen.refreshTasks();
                }
            });
        }
    }
}

