/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.MatterType;
import com.buuz135.replication.api.matter_fluid.IMatterHandler;
import com.buuz135.replication.recipe.MatterValueRecipe;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.recipe.serializer.CodecRecipeSerializer;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class ReplicationRegistry {
    public static final ResourceKey<Registry<IMatterType>> MATTER_TYPES_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"matter_types"));
    public static Registry<IMatterType> MATTER_TYPES_REGISTRY = null;

    public static void init(IEventBus modEvent) {
        CustomRecipeTypes.REC.register(modEvent);
        Serializers.SER.register(modEvent);
        ReplicationAttachments.DR.register(modEvent);
        Matter.IMATTER_TYPES.register(modEvent);
    }

    public static RegistryAccess registryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().registryAccess();
        }
        return ((Level)((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElseThrow()).registryAccess();
    }

    public static class CustomRecipeTypes {
        public static final DeferredRegister<RecipeType<?>> REC = DeferredRegister.create((ResourceKey)Registries.RECIPE_TYPE, (String)Replication.MOD_ID);
        public static final DeferredHolder<RecipeType<?>, RecipeType<?>> MATTER_VALUE_RECIPE_TYPE = REC.register("matter_value", () -> RecipeType.simple((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"matter_value")));
    }

    public static class Serializers {
        public static final DeferredRegister<RecipeSerializer<?>> SER = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)Replication.MOD_ID);
        public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<?>> MATTER_VALUE_RECIPE_SERIALIZER = SER.register("matter_value", () -> new CodecRecipeSerializer(MatterValueRecipe.class, CustomRecipeTypes.MATTER_VALUE_RECIPE_TYPE, MatterValueRecipe.CODEC));
    }

    public static class Matter {
        public static final DeferredRegister<IMatterType> IMATTER_TYPES = DeferredRegister.create(MATTER_TYPES_KEY, (String)Replication.MOD_ID);
        public static final DeferredHolder<IMatterType, IMatterType> EMPTY = IMATTER_TYPES.register("empty", () -> MatterType.EMPTY);
        public static final DeferredHolder<IMatterType, IMatterType> EARTH = IMATTER_TYPES.register("earth", () -> MatterType.EARTH);
        public static final DeferredHolder<IMatterType, IMatterType> NETHER = IMATTER_TYPES.register("nether", () -> MatterType.NETHER);
        public static final DeferredHolder<IMatterType, IMatterType> ORGANIC = IMATTER_TYPES.register("organic", () -> MatterType.ORGANIC);
        public static final DeferredHolder<IMatterType, IMatterType> ENDER = IMATTER_TYPES.register("ender", () -> MatterType.ENDER);
        public static final DeferredHolder<IMatterType, IMatterType> METALLIC = IMATTER_TYPES.register("metallic", () -> MatterType.METALLIC);
        public static final DeferredHolder<IMatterType, IMatterType> PRECIOUS = IMATTER_TYPES.register("precious", () -> MatterType.PRECIOUS);
        public static final DeferredHolder<IMatterType, IMatterType> LIVING = IMATTER_TYPES.register("living", () -> MatterType.LIVING);
        public static final DeferredHolder<IMatterType, IMatterType> QUANTUM = IMATTER_TYPES.register("quantum", () -> MatterType.QUANTUM);
    }

    public static class Items {
        public static DeferredHolder<Item, Item> MEMORY_CHIP;
        public static DeferredHolder<Item, Item> MATTER_BLUEPRINT;
        public static DeferredHolder<Item, Item> RAW_REPLICA;
        public static DeferredHolder<Item, Item> REPLICA_INGOT;
        public static DeferredHolder<Item, Item> CREATIVE_MEMORY_CHIP;
        public static DeferredHolder<Item, Item> REPLICATOR_ENCLOSURE;
        public static DeferredHolder<Item, Item> REPLICATOR_MOTOR;
    }

    public static class Capabilities {
        public static final BlockCapability<IMatterHandler, @Nullable Direction> MATTER_HANDLER = BlockCapability.createSided((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"matter_handler"), IMatterHandler.class);
    }

    public static class Colors {
        public static float[] GREEN_SPLIT = new float[]{0.09019608f, 0.8980392f, 0.09019608f};
        public static int GREEN = Mth.color((float)GREEN_SPLIT[0], (float)GREEN_SPLIT[1], (float)GREEN_SPLIT[2]);
    }

    public static class Sounds {
        public static DeferredHolder<SoundEvent, SoundEvent> TERMINAL_BUTTON = null;
    }

    public static class Blocks {
        public static BlockWithTile REPLICATOR = null;
        public static BlockWithTile IDENTIFICATION_CHAMBER = null;
        public static BlockWithTile DISINTEGRATOR = null;
        public static BlockWithTile MATTER_NETWORK_PIPE = null;
        public static BlockWithTile MATTER_TANK = null;
        public static BlockWithTile REPLICATION_TERMINAL = null;
        public static BlockWithTile CHIP_STORAGE = null;
        public static DeferredHolder<Block, Block> DEEPSLATE_REPLICA_ORE = null;
        public static DeferredHolder<Block, Block> REPLICA_BLOCK = null;
        public static DeferredHolder<Block, Block> RAW_REPLICA_BLOCK = null;
    }
}

