/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api;

import com.buuz135.replication.api.IMatterType;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public enum MatterType implements IMatterType
{
    EMPTY("empty", new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1),
    EARTH("earth", new float[]{0.37109375f, 0.81640625f, 0.30078125f, 1.0f}, 16),
    NETHER("nether", new float[]{0.67578125f, 0.01171875f, 0.125f, 1.0f}, 32),
    ORGANIC("organic", new float[]{0.81640625f, 0.59375f, 0.30078125f, 1.0f}, 16),
    ENDER("ender", new float[]{0.0f, 0.5078125f, 0.33984375f, 1.0f}, 32),
    METALLIC("metallic", new float[]{0.75f, 0.75f, 0.75f, 1.0f}, 128),
    PRECIOUS("precious", new float[]{0.92578125f, 0.8671875f, 0.47265625f, 1.0f}, 128),
    LIVING("living", new float[]{0.70703125f, 0.26953125f, 0.69140625f, 1.0f}, 32),
    QUANTUM("quantum", () -> {
        if (Minecraft.getInstance().level != null) {
            return new float[]{0.70703125f, 0.515625f, 0.88671875f, Mth.clamp((float)(Minecraft.getInstance().level.random.nextDouble() < 0.95 ? (float)(Math.sin((float)(Minecraft.getInstance().level.getGameTime() % 300L) / 30.0f) + 1.25) * 0.5f : 1.0f), (float)0.0f, (float)1.0f)};
        }
        return new float[]{0.70703125f, 0.515625f, 0.88671875f, 1.0f};
    }, 64);

    private final String name;
    private final Supplier<float[]> color;
    private final int max;

    private MatterType(String name, float[] color, int max) {
        this(name, () -> color, max);
    }

    private MatterType(String name, Supplier<float[]> color, int max) {
        this.name = name;
        this.color = color;
        this.max = max;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Supplier<float[]> getColor() {
        return this.color;
    }

    @Override
    public int getMax() {
        return this.max;
    }
}

