/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api.matter_fluid;

import com.buuz135.replication.api.matter_fluid.IMatterHandler;
import com.buuz135.replication.api.matter_fluid.IMatterTank;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class MatterTank
implements IMatterHandler,
IMatterTank,
INBTSerializable<CompoundTag> {
    protected Predicate<MatterStack> validator;
    @NotNull
    protected MatterStack matterStack = MatterStack.EMPTY;
    protected int capacity;

    public MatterTank(int capacity) {
        this(capacity, e -> true);
    }

    public MatterTank(int capacity, Predicate<MatterStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public MatterTank setValidator(Predicate<MatterStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    @Override
    public boolean isMatterValid(MatterStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public double getCapacity() {
        return this.capacity;
    }

    public MatterTank setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    @Override
    @NotNull
    public MatterStack getMatter() {
        return this.matterStack;
    }

    @Override
    public double getMatterAmount() {
        return this.matterStack.getAmount();
    }

    public MatterTank readFromNBT(CompoundTag nbt) {
        MatterStack fluid = MatterStack.loadMatterStackFromNBT(nbt);
        this.setMatter(fluid);
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.matterStack.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public int getTanks() {
        return 1;
    }

    @Override
    @NotNull
    public MatterStack getMatterInTank(int tank) {
        return this.getMatter();
    }

    @Override
    public double getTankCapacity(int tank) {
        return this.getCapacity();
    }

    @Override
    public boolean isMatterValid(int tank, @NotNull MatterStack stack) {
        return this.isMatterValid(stack);
    }

    @Override
    public double fill(MatterStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isMatterValid(resource)) {
            return 0.0;
        }
        if (action.simulate()) {
            if (this.matterStack.isEmpty()) {
                return Math.min((double)this.capacity, resource.getAmount());
            }
            if (!this.matterStack.isMatterEqual(resource)) {
                return 0.0;
            }
            return Math.min((double)this.capacity - this.matterStack.getAmount(), resource.getAmount());
        }
        if (this.matterStack.isEmpty()) {
            this.matterStack = new MatterStack(resource, Math.min((double)this.capacity, resource.getAmount()));
            this.onContentsChanged();
            return this.matterStack.getAmount();
        }
        if (!this.matterStack.isMatterEqual(resource)) {
            return 0.0;
        }
        double filled = (double)this.capacity - this.matterStack.getAmount();
        if (resource.getAmount() < filled) {
            this.matterStack.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.matterStack.setAmount(this.capacity);
        }
        if (filled > 0.0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @Override
    @NotNull
    public MatterStack drain(MatterStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isMatterEqual(this.matterStack)) {
            return MatterStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Override
    @NotNull
    public MatterStack drain(double maxDrain, IFluidHandler.FluidAction action) {
        double drained = maxDrain;
        if (this.matterStack.getAmount() < drained) {
            drained = this.matterStack.getAmount();
        }
        MatterStack stack = new MatterStack(this.matterStack, drained);
        if (action.execute() && drained > 0.0) {
            this.matterStack.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    public void setMatter(MatterStack stack) {
        this.matterStack = stack;
    }

    public boolean isEmpty() {
        return this.matterStack.isEmpty();
    }

    public double getSpace() {
        return Math.max(0.0, (double)this.capacity - this.matterStack.getAmount());
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.writeToNBT(new CompoundTag());
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readFromNBT(nbt);
    }
}

