/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.block;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.block.shapes.ReplicatorShapes;
import com.buuz135.replication.block.tile.ReplicatorBlockEntity;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.block_network.INetworkDirectionalConnection;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import com.hrznstudio.titanium.util.FacingUtil;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ReplicatorBlock
extends RotatableBlock<ReplicatorBlockEntity>
implements INetworkDirectionalConnection {
    public static BooleanProperty HAS_ENCLOSURE = BooleanProperty.create((String)"has_enclosure");
    public static BooleanProperty HAS_MOTOR = BooleanProperty.create((String)"has_motor");

    public ReplicatorBlock() {
        super("replicator", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK), ReplicatorBlockEntity.class);
        this.setItemGroup(Replication.TAB);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_ENCLOSURE, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_MOTOR, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return (pos, blockState) -> new ReplicatorBlockEntity((BasicTileBlock<ReplicatorBlockEntity>)this, (BlockEntityType<?>)((BlockEntityType)ReplicationRegistry.Blocks.REPLICATOR.type().get()), pos, blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        super.createBlockStateDefinition(p_206840_1_);
        p_206840_1_.add(new Property[]{HAS_ENCLOSURE, HAS_MOTOR});
    }

    @NotNull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction rotation = (Direction)state.getValue((Property)FACING_HORIZONTAL);
        if (rotation == Direction.NORTH) {
            return ReplicatorShapes.NORTH_FULL;
        }
        if (rotation == Direction.SOUTH) {
            return ReplicatorShapes.SOUTH_FULL;
        }
        if (rotation == Direction.EAST) {
            return ReplicatorShapes.EAST_FULL;
        }
        if (rotation == Direction.WEST) {
            return ReplicatorShapes.WEST_FULL;
        }
        return super.getCollisionShape(state, world, pos, selectionContext);
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        Direction rotation = (Direction)state.getValue((Property)FACING_HORIZONTAL);
        if (rotation == Direction.NORTH) {
            return ReplicatorShapes.NORTH_FULL;
        }
        if (rotation == Direction.SOUTH) {
            return ReplicatorShapes.SOUTH_FULL;
        }
        if (rotation == Direction.EAST) {
            return ReplicatorShapes.EAST_FULL;
        }
        if (rotation == Direction.WEST) {
            return ReplicatorShapes.WEST_FULL;
        }
        return super.getShape(state, p_60556_, p_60557_, p_60558_);
    }

    public Pair<VoxelShape, VoxelShape> getShapePlate(BlockState state) {
        Direction rotation = (Direction)state.getValue((Property)FACING_HORIZONTAL);
        if (rotation == Direction.NORTH) {
            return Pair.of((Object)ReplicatorShapes.NORTH, (Object)ReplicatorShapes.NORTH_PLATE);
        }
        if (rotation == Direction.SOUTH) {
            return Pair.of((Object)ReplicatorShapes.SOUTH, (Object)ReplicatorShapes.SOUTH_PLATE);
        }
        if (rotation == Direction.EAST) {
            return Pair.of((Object)ReplicatorShapes.EAST, (Object)ReplicatorShapes.EAST_PLATE);
        }
        if (rotation == Direction.WEST) {
            return Pair.of((Object)ReplicatorShapes.WEST, (Object)ReplicatorShapes.WEST_PLATE);
        }
        return Pair.of((Object)ReplicatorShapes.NORTH, (Object)ReplicatorShapes.NORTH_PLATE);
    }

    public boolean canConnect(Level level, BlockPos pos, BlockState state, Direction direction) {
        FacingUtil.Sideness sideness = FacingUtil.getFacingRelative((Direction)direction, (Direction)((Direction)state.getValue((Property)FACING_HORIZONTAL)));
        if (direction == Direction.UP) {
            return false;
        }
        return sideness == FacingUtil.Sideness.BOTTOM || sideness == FacingUtil.Sideness.BACK;
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("IP ").pattern("IRM").pattern("III").define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('I'), (ItemLike)ReplicationRegistry.Items.REPLICA_INGOT.get()).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).save(consumer);
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        NonNullList list = super.getDynamicDrops(state, worldIn, pos, newState, isMoving);
        if (((Boolean)state.getValue((Property)HAS_MOTOR)).booleanValue()) {
            list.add((Object)new ItemStack(ReplicationRegistry.Items.REPLICATOR_MOTOR));
        }
        if (((Boolean)state.getValue((Property)HAS_ENCLOSURE)).booleanValue()) {
            list.add((Object)new ItemStack(ReplicationRegistry.Items.REPLICATOR_ENCLOSURE));
        }
        return list;
    }
}

