/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.compat;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.client.gui.ReplicationTerminalScreen;
import com.buuz135.replication.compat.jei.ReplicationTerminalScreenHandler;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration registration) {
        super.registerItemSubtypes(registration);
        registration.registerSubtypeInterpreter(ReplicationRegistry.Blocks.MATTER_TANK.asItem(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                return List.of((CompoundTag)ingredient.getOrDefault(ReplicationAttachments.TILE, (Object)new CompoundTag()));
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return ((CompoundTag)ingredient.getOrDefault(ReplicationAttachments.TILE, (Object)new CompoundTag())).toString();
            }
        });
        registration.registerSubtypeInterpreter((Item)ReplicationRegistry.Items.MATTER_BLUEPRINT.get(), (ISubtypeInterpreter)new ISubtypeInterpreter<ItemStack>(this){

            @Nullable
            public Object getSubtypeData(ItemStack ingredient, UidContext context) {
                ArrayList<Object> list = new ArrayList<Object>();
                if (ingredient.has(ReplicationAttachments.BLUEPRINT)) {
                    list.add(((CompoundTag)ingredient.get(ReplicationAttachments.BLUEPRINT)).getCompound("Item").getString("id"));
                    list.add(((CompoundTag)ingredient.get(ReplicationAttachments.BLUEPRINT)).getDouble("Progress"));
                } else {
                    list.add(ItemStack.EMPTY);
                    list.add(0);
                }
                return list;
            }

            public String getLegacyStringSubtypeInfo(ItemStack ingredient, UidContext context) {
                return "";
            }
        });
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"replication");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        super.registerGuiHandlers(registration);
        registration.addGuiContainerHandler(ReplicationTerminalScreen.class, (IGuiContainerHandler)new ReplicationTerminalScreenHandler());
    }
}

