/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.container.component;

import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.api.matter_fluid.component.MatterTankComponent;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.IComponentHandler;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.util.LangUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class LockableMatterTankBundle<T extends BasicTile>
implements IComponentBundle,
INBTSerializable<CompoundTag> {
    private MatterTankComponent<T> inventory;
    private Predicate<MatterStack> cachedFilter;
    private ButtonComponent buttonAddon;
    private T componentHarness;
    private MatterStack filter;
    private int lockPosX;
    private int lockPosY;
    private boolean isLocked;

    public LockableMatterTankBundle(T componentHarness, final MatterTankComponent<T> inventory, int lockPosX, int lockPosY, boolean isLocked) {
        this.componentHarness = componentHarness;
        this.inventory = inventory;
        this.cachedFilter = inventory.getInsertPredicate();
        this.filter = MatterStack.EMPTY;
        this.lockPosX = lockPosX;
        this.lockPosY = lockPosY;
        this.isLocked = isLocked;
        this.buttonAddon = new ButtonComponent(lockPosX, lockPosY, 14, 14){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new StateButtonAddon(LockableMatterTankBundle.this.buttonAddon, new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_UNLOCKED, new String[]{String.valueOf(ChatFormatting.GOLD) + LangUtil.getString((String)"tooltip.titanium.locks", (Object[])new Object[0]) + String.valueOf(ChatFormatting.WHITE) + " " + LangUtil.getString((String)("tooltip.titanium.facing_handler." + inventory.getName().toLowerCase()), (Object[])new Object[0])}), new StateButtonInfo(1, AssetTypes.BUTTON_LOCKED, new String[]{String.valueOf(ChatFormatting.GOLD) + LangUtil.getString((String)"tooltip.titanium.unlocks", (Object[])new Object[0]) + String.valueOf(ChatFormatting.WHITE) + " " + LangUtil.getString((String)("tooltip.titanium.facing_handler." + inventory.getName().toLowerCase()), (Object[])new Object[0]), Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.replication.tank.matter").getString())).getString() + String.valueOf(ChatFormatting.WHITE) + (LockableMatterTankBundle.this.filter.isEmpty() ? Component.translatable((String)"tooltip.titanium.tank.empty").getString() : Component.translatable((String)LockableMatterTankBundle.this.filter.getTranslationKey()).getString())})}){

                    public int getState() {
                        return LockableMatterTankBundle.this.isLocked ? 1 : 0;
                    }
                });
            }
        }.setPredicate((playerEntity, compoundNBT) -> {
            this.isLocked = !this.isLocked;
            this.filter = this.inventory.getMatter();
            this.updateFilter();
            this.componentHarness.syncObject((Object)this);
        });
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        return Collections.emptyList();
    }

    public void accept(IComponentHandler ... handler) {
        for (IComponentHandler iComponentHandler : handler) {
            iComponentHandler.add(new Object[]{this.buttonAddon});
        }
    }

    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Collections.emptyList();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("Tank", (Tag)this.inventory.serializeNBT(provider));
        compoundNBT.putBoolean("Locked", this.isLocked);
        compoundNBT.put("Filter", (Tag)this.filter.writeToNBT(new CompoundTag()));
        return compoundNBT;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.inventory.deserializeNBT(provider, nbt.getCompound("Tank"));
        this.isLocked = nbt.getBoolean("Locked");
        this.filter = MatterStack.loadMatterStackFromNBT(nbt.getCompound("Filter"));
        this.updateFilter();
    }

    private void updateFilter() {
        if (this.isLocked) {
            this.inventory.setInputFilter(stack -> this.filter.isMatterEqual((MatterStack)stack));
        } else {
            this.filter = MatterStack.EMPTY;
            this.inventory.setInputFilter(this.cachedFilter);
        }
    }

    public MatterTankComponent<T> getTank() {
        return this.inventory;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public MatterStack getFilter() {
        return this.filter;
    }

    public void setFilter(MatterStack filter) {
        this.filter = filter;
    }
}

