/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api.matter_fluid;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.MatterType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MatterStack {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MatterStack EMPTY = new MatterStack(MatterType.EMPTY, 0.0);
    private boolean isEmpty;
    private double amount;
    private final IMatterType matter;

    public MatterStack(IMatterType matter, double amount) {
        if (matter == null) {
            LOGGER.fatal("Null fluid supplied to matterstack. Did you try and create a stack for an unregistered matter?");
            throw new IllegalArgumentException("Cannot create a matterstack from a null fluid");
        }
        if (ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)matter) == null) {
            LOGGER.fatal("Failed attempt to create a MatterStack for an unregistered Matter {} (type {})", (Object)ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)matter), (Object)matter.getClass().getName());
            throw new IllegalArgumentException("Cannot create a MatterStack from an unregistered fluid");
        }
        this.matter = matter;
        this.amount = amount;
        this.updateEmpty();
    }

    public MatterStack(MatterStack matterStack, double amount) {
        this(matterStack.getMatterType(), amount);
    }

    public static MatterStack loadMatterStackFromNBT(CompoundTag nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.contains("MatterName", 8)) {
            return EMPTY;
        }
        ResourceLocation matterName = ResourceLocation.parse((String)nbt.getString("MatterName"));
        IMatterType matterType = (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.get(matterName);
        if (matterType == null) {
            return EMPTY;
        }
        MatterStack stack = new MatterStack(matterType, nbt.getDouble("Amount"));
        return stack;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putString("MatterName", ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)this.getMatterType()).toString());
        nbt.putDouble("Amount", this.amount);
        return nbt;
    }

    public final IMatterType getMatterType() {
        return this.isEmpty ? MatterType.EMPTY : this.matter;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    protected void updateEmpty() {
        this.isEmpty = this.getMatterType() == MatterType.EMPTY || this.amount <= 0.0;
    }

    public double getAmount() {
        return this.isEmpty ? 0.0 : this.amount;
    }

    public void setAmount(double amount) {
        if (this.getMatterType() == MatterType.EMPTY) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.amount = amount;
        this.updateEmpty();
    }

    public void grow(double amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(double amount) {
        this.setAmount(this.amount - amount);
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return "replication.matter_type." + this.getMatterType().getName();
    }

    public MatterStack copy() {
        return new MatterStack(this.getMatterType(), this.amount);
    }

    public boolean isMatterEqual(@NotNull MatterStack other) {
        return this.getMatterType() == other.getMatterType();
    }

    public boolean containsMatter(@NotNull MatterStack other) {
        return this.isMatterEqual(other) && this.amount >= other.amount;
    }

    public boolean isMatterStackIdentical(MatterStack other) {
        return this.isMatterEqual(other) && this.amount == other.amount;
    }

    public boolean isMatterEqual(@NotNull ItemStack other) {
        return false;
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getMatterType().hashCode();
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof MatterStack)) {
            return false;
        }
        return this.isMatterEqual((MatterStack)o);
    }
}

