/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.api.matter_fluid.component;

import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.api.matter_fluid.MatterTank;
import com.buuz135.replication.api.matter_fluid.client.MatterTankScreenAddon;
import com.google.common.collect.Lists;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MatterTankComponent<T extends IComponentHarness>
extends MatterTank
implements IScreenAddonProvider,
IContainerAddonProvider,
INBTSerializable<CompoundTag> {
    private final int posX;
    private final int posY;
    private String name;
    private T componentHarness;
    private FluidTankComponent.Type tankType;
    private FluidTankComponent.Action tankAction;
    private Runnable onContentChange;
    private Predicate<MatterStack> insertPredicate;

    public MatterTankComponent(String name, int amount, int posX, int posY) {
        super(amount);
        this.posX = posX;
        this.posY = posY;
        this.name = name;
        this.tankType = FluidTankComponent.Type.NORMAL;
        this.tankAction = FluidTankComponent.Action.BOTH;
        this.onContentChange = () -> {};
        this.insertPredicate = stack -> true;
    }

    public MatterTankComponent<T> setComponentHarness(T componentHarness) {
        this.componentHarness = componentHarness;
        return this;
    }

    public T getComponentHarness() {
        return this.componentHarness;
    }

    @Override
    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.componentHarness != null) {
            // empty if block
        }
        this.onContentChange.run();
    }

    public String getName() {
        return this.name;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public FluidTankComponent.Type getTankType() {
        return this.tankType;
    }

    public MatterTankComponent<T> setTankType(FluidTankComponent.Type tankType) {
        this.tankType = tankType;
        return this;
    }

    public MatterTankComponent<T> setOnContentChange(Runnable onContentChange) {
        this.onContentChange = onContentChange;
        return this;
    }

    public FluidTankComponent.Action getTankAction() {
        return this.tankAction;
    }

    public MatterTankComponent<T> setTankAction(FluidTankComponent.Action tankAction) {
        this.tankAction = tankAction;
        return this;
    }

    public MatterTankComponent<T> setInputFilter(Predicate<MatterStack> predicate) {
        this.insertPredicate = predicate;
        return this;
    }

    public Predicate<MatterStack> getInsertPredicate() {
        return this.insertPredicate;
    }

    @Override
    public double fill(MatterStack resource, IFluidHandler.FluidAction action) {
        return this.getTankAction().canFill() && this.insertPredicate.test(resource) ? super.fill(resource, action) : 0.0;
    }

    @Override
    @Nonnull
    public MatterStack drain(MatterStack resource, IFluidHandler.FluidAction action) {
        return this.getTankAction().canDrain() ? this.drainInternal(resource, action) : MatterStack.EMPTY;
    }

    private MatterStack drainInternal(MatterStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isMatterEqual(this.matterStack)) {
            return MatterStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Override
    @Nonnull
    public MatterStack drain(double maxDrain, IFluidHandler.FluidAction action) {
        return this.getTankAction().canDrain() ? this.drainInternal(maxDrain, action) : MatterStack.EMPTY;
    }

    @Nonnull
    private MatterStack drainInternal(double maxDrain, IFluidHandler.FluidAction action) {
        double drained = maxDrain;
        if (this.matterStack.getAmount() < drained) {
            drained = this.matterStack.getAmount();
        }
        MatterStack stack = new MatterStack(this.matterStack, drained);
        if (action.execute() && drained > 0.0) {
            this.matterStack.shrink(drained);
            this.onContentsChanged();
        }
        return stack;
    }

    public double fillForced(MatterStack resource, IFluidHandler.FluidAction action) {
        return super.fill(resource, action);
    }

    @Nonnull
    public MatterStack drainForced(MatterStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isMatterEqual(this.matterStack)) {
            return MatterStack.EMPTY;
        }
        return this.drainForced(resource.getAmount(), action);
    }

    @Nonnull
    public MatterStack drainForced(double maxDrain, IFluidHandler.FluidAction action) {
        return this.drainInternal(maxDrain, action);
    }

    public void setMatterStack(MatterStack MatterStack2) {
        this.matterStack = MatterStack2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> addons = new ArrayList<IFactory<? extends IScreenAddon>>();
        addons.add(() -> new MatterTankScreenAddon(this.posX, this.posY, this, this.tankType));
        return addons;
    }

    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        return Lists.newArrayList();
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.writeToNBT(new CompoundTag());
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.readFromNBT(nbt);
    }

    public Runnable getOnContentChange() {
        return this.onContentChange;
    }
}

