/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.calculation;

import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.hrznstudio.titanium.network.CompoundSerializableDataHandler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MatterValue
implements INBTSerializable<CompoundTag> {
    public static final Codec<MatterValue> CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("type").forGetter(o -> ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)o.matter)), (App)Codec.DOUBLE.fieldOf("amount").forGetter(MatterValue::getAmount)).apply((Applicative)instance, MatterValue::new)));
    private IMatterType matter;
    private double amount;

    public MatterValue(ResourceLocation matter, double amount) {
        this((IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.get(matter), amount);
    }

    public MatterValue(IMatterType matter, double amount) {
        this.matter = matter;
        this.amount = amount;
    }

    public MatterValue add(double amount) {
        this.amount += amount;
        return this;
    }

    public IMatterType getMatter() {
        return this.matter;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String toString() {
        return "MatterValue{matter=" + String.valueOf(this.matter) + ", amount=" + this.amount + "}";
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("amount", this.amount);
        tag.putString("matter", ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)this.matter).toString());
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.amount = compoundTag.getDouble("amount");
        this.matter = (IMatterType)ReplicationRegistry.MATTER_TYPES_REGISTRY.get(ResourceLocation.parse((String)compoundTag.getString("matter")));
    }

    static {
        CompoundSerializableDataHandler.map(MatterValue.class, buf -> (MatterValue)buf.readJsonWithCodec(CODEC), (buf, value) -> buf.writeJsonWithCodec(CODEC, value));
    }
}

