/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.gui.addons;

import com.buuz135.replication.Replication;
import com.buuz135.replication.block.ReplicatorBlock;
import com.buuz135.replication.block.tile.ReplicatorBlockEntity;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.client.screen.addon.WidgetScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.properties.Property;

public class ReplicatorMotorAddon
extends WidgetScreenAddon {
    public static ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"textures/gui/toasts.png");
    private final ReplicatorBlockEntity blockEntity;
    private EditBox editBox;
    private String lastValue;

    public ReplicatorMotorAddon(ReplicatorBlockEntity blockEntity, int posX, int posY) {
        super(posX, posY, (AbstractWidget)new EditBox(Minecraft.getInstance().font, 85, 20, 160, 26, (Component)Component.translatable((String)"itemGroup.search")));
        this.blockEntity = blockEntity;
        this.lastValue = "";
        this.editBox = (EditBox)this.getWidget();
        this.editBox.setValue("" + blockEntity.getMotorSpeedMultiplier());
        this.editBox.setFilter(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int value = Integer.parseInt(s);
                if (value <= 100) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return false;
        });
        this.editBox.setMaxLength(3);
        this.editBox.setBordered(false);
        this.editBox.setVisible(true);
        this.editBox.setTextColor(7529831);
    }

    public int getXSize() {
        return 0;
    }

    public int getYSize() {
        return 0;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.blockEntity.getBlockState().hasProperty((Property)ReplicatorBlock.HAS_MOTOR) && ((Boolean)this.blockEntity.getBlockState().getValue((Property)ReplicatorBlock.HAS_MOTOR)).booleanValue()) {
            this.editBox.setResponder(s -> {
                AbstractContainerScreen containerScreen;
                AbstractContainerMenu patt0$temp;
                if (s.isEmpty()) {
                    return;
                }
                if (!this.lastValue.equals(s) && screen instanceof AbstractContainerScreen && (patt0$temp = (containerScreen = (AbstractContainerScreen)screen).getMenu()) instanceof ILocatable) {
                    ILocatable locatable = (ILocatable)patt0$temp;
                    CompoundTag compound = new CompoundTag();
                    compound.putInt("Multiplier", Integer.parseInt(s));
                    Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage(locatable.getLocatorInstance(), 124578, compound));
                    new Thread(() -> {
                        try {
                            Thread.sleep(5000L);
                            this.editBox.setValue("" + this.blockEntity.getMotorSpeedMultiplier());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }).start();
                }
                this.lastValue = s;
            });
            super.drawBackgroundLayer(guiGraphics, screen, iAssetProvider, guiX, guiY, mouseX, mouseY, partialTicks);
            guiGraphics.blit(TEXTURE, guiX + this.getPosX(), guiY + this.getPosY(), 0, 0, 160, 30);
            guiGraphics.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"tooltip.replication_motor.acceleration"), guiX + this.getPosX() + 7, guiY + this.getPosY() + 8, 7529831, false);
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)(11 + Minecraft.getInstance().font.width(Component.translatable((String)"tooltip.replication_motor.acceleration").getString())), 8.0f, 0.0f);
            this.editBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            guiGraphics.pose().popPose();
            guiGraphics.drawString(Minecraft.getInstance().font, "%", guiX + this.getPosX() + 12 + Minecraft.getInstance().font.width(Component.translatable((String)"tooltip.replication_motor.acceleration").getString()) + Minecraft.getInstance().font.width("000"), guiY + this.getPosY() + 8, 7529831, false);
            Font font = Minecraft.getInstance().font;
            MutableComponent mutableComponent = Component.translatable((String)"tooltip.replication_motor.failure_chance").append((Component)Component.literal((String)("" + this.blockEntity.getFailureChance())).withStyle(ChatFormatting.RED)).append(" %");
            int n = guiX + this.getPosX() + 7;
            int n2 = guiY + this.getPosY() + 8;
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font, (Component)mutableComponent, n, n2 + 9, 7529831, false);
        }
    }

    public void drawForegroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider iAssetProvider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (!this.blockEntity.getBlockState().hasProperty((Property)ReplicatorBlock.HAS_MOTOR) || ((Boolean)this.blockEntity.getBlockState().getValue((Property)ReplicatorBlock.HAS_MOTOR)).booleanValue()) {
            // empty if block
        }
    }
}

