/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.client.render;

import com.buuz135.replication.block.tile.DisintegratorBlockEntity;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class DisintegratorRenderer<T extends DisintegratorBlockEntity>
implements BlockEntityRenderer<T> {
    public static BakedModel BLADE = null;

    public DisintegratorRenderer(BlockEntityRendererProvider.Context p_173689_) {
    }

    public void render(T tile, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        Direction facing = (Direction)tile.getBlockState().getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        if (facing == Direction.EAST) {
            poseStack.translate(1.0f, 0.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        } else if (facing == Direction.SOUTH) {
            poseStack.translate(1.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
        } else if (facing == Direction.WEST) {
            poseStack.translate(0.0f, 0.0f, 1.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        poseStack.translate(0.5f, 0.505f, 0.38f);
        float speed = 20.0f;
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.505f, 0.0f);
        long time = tile.getLevel().getGameTime() % 36000L;
        poseStack.mulPose(Axis.YP.rotationDegrees((float)time % (360.0f / speed) * speed + v));
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), multiBufferSource.getBuffer(RenderType.cutout()), null, BLADE, 255.0f, 255.0f, 255.0f, combinedLightIn, combinedOverlayIn);
        poseStack.popPose();
        for (int i = 0; i < ((DisintegratorBlockEntity)tile).getInput().getSlots(); ++i) {
            float scale = 0.3f;
            ItemStack stack = ((DisintegratorBlockEntity)tile).getInput().getStackInSlot(i);
            if (stack.isEmpty()) continue;
            BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)Minecraft.getInstance().level, null, 0);
            if (model.isGui3d()) {
                scale = 0.475f;
            }
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(120.0f * (float)i));
            poseStack.mulPose(Axis.YP.rotationDegrees((float)time % (360.0f / speed) * speed + v));
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)(time % 360L) + 120.0f * (float)(i + 1) + v));
            poseStack.translate(0.0, -0.05, -0.2);
            poseStack.scale(scale, scale, scale);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, multiBufferSource, tile.getLevel(), 0);
            poseStack.popPose();
        }
    }
}

