/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.network;

import com.buuz135.replication.Replication;
import com.buuz135.replication.ReplicationRegistry;
import com.buuz135.replication.api.IMatterType;
import com.buuz135.replication.api.matter_fluid.IMatterTank;
import com.buuz135.replication.api.matter_fluid.MatterStack;
import com.buuz135.replication.api.network.IMatterTanksConsumer;
import com.buuz135.replication.api.network.IMatterTanksSupplier;
import com.buuz135.replication.api.pattern.IMatterPatternHolder;
import com.buuz135.replication.api.pattern.MatterPattern;
import com.buuz135.replication.api.task.IReplicationTask;
import com.buuz135.replication.block.tile.MatterPipeBlockEntity;
import com.buuz135.replication.block.tile.ReplicationTerminalBlockEntity;
import com.buuz135.replication.block.tile.ReplicatorBlockEntity;
import com.buuz135.replication.network.task.ReplicationTaskManager;
import com.buuz135.replication.packet.MatterFluidSyncPacket;
import com.buuz135.replication.packet.PatternSyncStoragePacket;
import com.buuz135.replication.packet.TaskCancelPacket;
import com.buuz135.replication.packet.TaskSyncPacket;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.NetworkFactory;
import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.network.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MatterNetwork
extends Network {
    public static ResourceLocation MATTER = ResourceLocation.fromNamespaceAndPath((String)Replication.MOD_ID, (String)"matter");
    private EnergyStorage energyStorage;
    private List<NetworkElement> matterStacksConsumers;
    private List<NetworkElement> matterStacksSuppliers;
    private List<NetworkElement> matterStacksHolders;
    private List<NetworkElement> queueNetworkElements;
    private List<NetworkElement> chipSuppliers;
    private List<NetworkElement> terminals;
    private List<NetworkElement> replicators;
    private List<NetworkElement> pipes;
    private ReplicationTaskManager taskManager;

    public MatterNetwork(BlockPos originPos, String id, int power, ReplicationTaskManager taskManager) {
        super(originPos, id);
        this.energyStorage = new EnergyStorage(100000, 100000, 100000, power);
        this.matterStacksConsumers = new ArrayList<NetworkElement>();
        this.matterStacksSuppliers = new ArrayList<NetworkElement>();
        this.matterStacksHolders = new ArrayList<NetworkElement>();
        this.queueNetworkElements = new ArrayList<NetworkElement>();
        this.chipSuppliers = new ArrayList<NetworkElement>();
        this.terminals = new ArrayList<NetworkElement>();
        this.replicators = new ArrayList<NetworkElement>();
        this.pipes = new ArrayList<NetworkElement>();
        this.taskManager = taskManager;
    }

    public void addElement(NetworkElement element) {
        this.queueNetworkElements.add(element);
    }

    public void removeElement(NetworkElement element) {
        this.matterStacksHolders.remove(element);
        this.matterStacksSuppliers.remove(element);
        this.matterStacksConsumers.remove(element);
        this.chipSuppliers.remove(element);
        this.terminals.remove(element);
        this.replicators.remove(element);
    }

    public void update(Level level) {
        super.update(level);
        for (NetworkElement element : this.queueNetworkElements) {
            if (!element.getLevel().isLoaded(element.getPos())) continue;
            BlockEntity tile = element.getLevel().getBlockEntity(element.getPos());
            if (tile instanceof IMatterTanksSupplier && tile instanceof IMatterTanksConsumer) {
                this.matterStacksHolders.add(element);
            } else if (tile instanceof IMatterTanksSupplier) {
                this.matterStacksSuppliers.add(element);
            } else if (tile instanceof IMatterTanksConsumer) {
                this.matterStacksConsumers.add(element);
            } else if (tile instanceof IMatterPatternHolder) {
                this.chipSuppliers.add(element);
            } else if (tile instanceof ReplicationTerminalBlockEntity) {
                this.terminals.add(element);
            }
            if (tile instanceof ReplicatorBlockEntity) {
                this.replicators.add(element);
            }
            if (!(tile instanceof MatterPipeBlockEntity)) continue;
            MatterPipeBlockEntity matterPipeBlockEntity = (MatterPipeBlockEntity)tile;
            this.pipes.add(element);
            matterPipeBlockEntity.setNeedsToRecreateEnergyStorage(true);
        }
        this.queueNetworkElements.clear();
        if (level.getGameTime() % 5L == 0L) {
            for (NetworkElement matterStacksSupplier : this.matterStacksSuppliers) {
                BlockEntity origin;
                if (matterStacksSupplier.getLevel() != level || !matterStacksSupplier.getLevel().isLoaded(matterStacksSupplier.getPos()) || !((origin = matterStacksSupplier.getLevel().getBlockEntity(matterStacksSupplier.getPos())) instanceof IMatterTanksSupplier)) continue;
                IMatterTanksSupplier supplier = (IMatterTanksSupplier)origin;
                block2: for (IMatterTank iMatterTank : supplier.getTanks()) {
                    IMatterTanksConsumer consumerDestination;
                    BlockEntity destination;
                    if (iMatterTank.getMatter().isEmpty()) continue;
                    boolean didWork = false;
                    for (NetworkElement destinationElement : this.matterStacksHolders) {
                        if (!destinationElement.getLevel().isLoaded(destinationElement.getPos()) || !((destination = destinationElement.getLevel().getBlockEntity(destinationElement.getPos())) instanceof IMatterTanksConsumer)) continue;
                        consumerDestination = (IMatterTanksConsumer)destination;
                        for (IMatterTank iMatterTank2 : consumerDestination.getTanks()) {
                            if (!iMatterTank2.getMatter().isMatterEqual(iMatterTank.getMatter()) || !(iMatterTank2.getMatterAmount() < iMatterTank2.getCapacity())) continue;
                            iMatterTank.drain(iMatterTank2.fill(iMatterTank.drain(iMatterTank2.getCapacity(), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                            didWork = true;
                            break;
                        }
                        if (!didWork) continue;
                        break;
                    }
                    if (didWork || iMatterTank.getMatter().isEmpty()) continue;
                    for (NetworkElement destinationElement : this.matterStacksHolders) {
                        if (!destinationElement.getLevel().isLoaded(destinationElement.getPos()) || !((destination = destinationElement.getLevel().getBlockEntity(destinationElement.getPos())) instanceof IMatterTanksConsumer)) continue;
                        consumerDestination = (IMatterTanksConsumer)destination;
                        for (IMatterTank iMatterTank3 : consumerDestination.getTanks()) {
                            if (!iMatterTank3.getMatter().isEmpty()) continue;
                            iMatterTank.drain(iMatterTank3.fill(iMatterTank.drain(iMatterTank3.getCapacity(), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                            didWork = true;
                            break;
                        }
                        if (!didWork) continue;
                        continue block2;
                    }
                }
            }
        }
        this.getTaskManager().getPendingTasks().values().forEach(task -> {
            if (task.isDirty()) {
                for (NetworkElement terminal : this.terminals) {
                    BlockEntity tile;
                    if (!terminal.getLevel().isLoaded(terminal.getPos()) || !((tile = terminal.getLevel().getBlockEntity(terminal.getPos())) instanceof ReplicationTerminalBlockEntity)) continue;
                    ReplicationTerminalBlockEntity terminalBlockEntity = (ReplicationTerminalBlockEntity)tile;
                    terminalBlockEntity.getTerminalPlayerTracker().getPlayers().forEach(serverPlayer -> this.sendTaskSyncPacket((ServerPlayer)serverPlayer, (IReplicationTask)task));
                }
                task.markDirty(false);
            }
        });
    }

    private void transfer(Level level, IMatterTanksSupplier supplier, List<NetworkElement> consumers, BiPredicate<MatterStack, MatterStack> stackPredicate, boolean shouldBreakWhenFound) {
        for (NetworkElement matterStacksHolder : consumers) {
            BlockEntity destination;
            if (matterStacksHolder.getLevel() != level || !((destination = matterStacksHolder.getLevel().getBlockEntity(matterStacksHolder.getPos())) instanceof IMatterTanksConsumer)) continue;
            IMatterTanksConsumer consumer = (IMatterTanksConsumer)destination;
            for (IMatterTank iMatterTank : supplier.getTanks()) {
                if (iMatterTank.getMatter().isEmpty()) continue;
                for (IMatterTank iMatterTank2 : consumer.getTanks()) {
                    if (!stackPredicate.test(iMatterTank.getMatter(), iMatterTank2.getMatter())) continue;
                    iMatterTank.drain(iMatterTank2.fill(iMatterTank.drain(4096.0, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    if (!shouldBreakWhenFound) continue;
                    return;
                }
            }
        }
    }

    public void onChipValuesChanged(IMatterPatternHolder blockEntity, BlockPos pos) {
        for (NetworkElement terminal : this.terminals) {
            BlockEntity tile;
            if (!terminal.getLevel().isLoaded(terminal.getPos()) || !((tile = terminal.getLevel().getBlockEntity(terminal.getPos())) instanceof ReplicationTerminalBlockEntity)) continue;
            ReplicationTerminalBlockEntity terminalBlockEntity = (ReplicationTerminalBlockEntity)tile;
            terminalBlockEntity.getTerminalPlayerTracker().getPlayers().forEach(serverPlayer -> this.sendPatternSyncPacket((ServerPlayer)serverPlayer, blockEntity, pos));
        }
    }

    public void onTankValueChanged(IMatterType matterType) {
        for (NetworkElement terminal : this.terminals) {
            BlockEntity tile;
            if (!terminal.getLevel().isLoaded(terminal.getPos()) || !((tile = terminal.getLevel().getBlockEntity(terminal.getPos())) instanceof ReplicationTerminalBlockEntity)) continue;
            ReplicationTerminalBlockEntity terminalBlockEntity = (ReplicationTerminalBlockEntity)tile;
            terminalBlockEntity.getTerminalPlayerTracker().getPlayers().forEach(serverPlayer -> this.sendMatterSyncPacket((ServerPlayer)serverPlayer, this.calculateMatterAmount(matterType), matterType));
        }
    }

    public void onTaskValueChanged(IReplicationTask task, ServerLevel serverLevel) {
        task.markDirty(true);
        if (task.getTotalAmount() == task.getCurrentAmount()) {
            for (NetworkElement terminal : this.terminals) {
                BlockEntity tile;
                if (!terminal.getLevel().isLoaded(terminal.getPos()) || !((tile = terminal.getLevel().getBlockEntity(terminal.getPos())) instanceof ReplicationTerminalBlockEntity)) continue;
                ReplicationTerminalBlockEntity terminalBlockEntity = (ReplicationTerminalBlockEntity)tile;
                terminalBlockEntity.getTerminalPlayerTracker().getPlayers().forEach(serverPlayer -> this.sendTaskSyncPacket((ServerPlayer)serverPlayer, task));
            }
        }
        this.markDirty(serverLevel);
    }

    public void sendTaskSyncPacket(ServerPlayer serverPlayer, IReplicationTask task) {
        Replication.NETWORK.sendTo((Message)new TaskSyncPacket(this.getId(), task.getUuid().toString(), (CompoundTag)task.serializeNBT((HolderLookup.Provider)serverPlayer.level().registryAccess())), serverPlayer);
    }

    public long calculateMatterAmount(IMatterType matterType) {
        long amount = 0L;
        for (NetworkElement matterStacksSupplier : this.getMatterStacksHolders()) {
            BlockEntity tile;
            if (!matterStacksSupplier.getLevel().isLoaded(matterStacksSupplier.getPos()) || !((tile = matterStacksSupplier.getLevel().getBlockEntity(matterStacksSupplier.getPos())) instanceof IMatterTanksSupplier)) continue;
            IMatterTanksSupplier tanksSupplier = (IMatterTanksSupplier)tile;
            for (IMatterTank iMatterTank : tanksSupplier.getTanks()) {
                if (!iMatterTank.getMatter().getMatterType().equals(matterType)) continue;
                amount = (long)((double)amount + iMatterTank.getMatterAmount());
            }
        }
        return amount;
    }

    public void sendPatternSyncPacket(ServerPlayer serverPlayer, IMatterPatternHolder holder, BlockPos blockPos) {
        List<MatterPattern> patterns = holder.getPatterns(serverPlayer.level(), holder);
        Replication.NETWORK.sendTo((Message)new PatternSyncStoragePacket(this.getId(), blockPos.asLong(), patterns.stream().map(MatterPattern::getStack).toList()), serverPlayer);
    }

    public void sendMatterSyncPacket(ServerPlayer serverPlayer, long amount, IMatterType type) {
        Replication.NETWORK.sendTo((Message)new MatterFluidSyncPacket(this.getId(), amount, ReplicationRegistry.MATTER_TYPES_REGISTRY.getKey((Object)type)), serverPlayer);
    }

    public void markDirty(ServerLevel serverLevel) {
        NetworkManager.get((ServerLevel)serverLevel).setDirty(true);
    }

    public List<NetworkElement> getChipSuppliers() {
        return this.chipSuppliers;
    }

    public List<NetworkElement> getMatterStacksSuppliers() {
        return this.matterStacksSuppliers;
    }

    public List<NetworkElement> getMatterStacksConsumers() {
        return this.matterStacksConsumers;
    }

    public List<NetworkElement> getMatterStacksHolders() {
        return this.matterStacksHolders;
    }

    public List<NetworkElement> getTerminals() {
        return this.terminals;
    }

    public List<NetworkElement> getReplicators() {
        return this.replicators;
    }

    public void onMergedWith(Network mainNetwork) {
        if (mainNetwork instanceof MatterNetwork) {
            MatterNetwork matterNetwork = (MatterNetwork)mainNetwork;
            matterNetwork.energyStorage.receiveEnergy(this.energyStorage.getEnergyStored(), false);
            matterNetwork.taskManager.getPendingTasks().putAll(this.getTaskManager().getPendingTasks());
            for (NetworkElement pipe : this.pipes) {
                BlockEntity blockEntity;
                if (!pipe.getLevel().isLoaded(pipe.getPos()) || !((blockEntity = pipe.getLevel().getBlockEntity(pipe.getPos())) instanceof MatterPipeBlockEntity)) continue;
                MatterPipeBlockEntity matterPipeBlockEntity = (MatterPipeBlockEntity)blockEntity;
                matterPipeBlockEntity.setNeedsToRecreateEnergyStorage(true);
            }
        }
    }

    public CompoundTag writeToNbt(CompoundTag tag) {
        CompoundTag nbt = super.writeToNbt(tag);
        nbt.putInt("Power", this.energyStorage.getEnergyStored());
        nbt.put("TaskManager", (Tag)this.taskManager.serializeNBT((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess()));
        return nbt;
    }

    public ResourceLocation getType() {
        return MATTER;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public ReplicationTaskManager getTaskManager() {
        return this.taskManager;
    }

    public void cancelTask(String task, Level level) {
        IReplicationTask replicationTask = this.getTaskManager().getPendingTasks().remove(task);
        if (replicationTask != null) {
            for (Long l : replicationTask.getReplicatorsOnTask()) {
                Object object;
                BlockPos pos = BlockPos.of((long)l);
                if (!level.isLoaded(pos) || !((object = level.getBlockEntity(pos)) instanceof ReplicatorBlockEntity)) continue;
                ReplicatorBlockEntity replicatorBlockEntity = (ReplicatorBlockEntity)((Object)object);
                replicatorBlockEntity.cancelTask();
            }
            for (List list : replicationTask.getStoredMatterStack().values()) {
                for (MatterStack matterStack : list) {
                    IMatterTanksConsumer consumer;
                    BlockEntity destination;
                    for (NetworkElement matterStacksHolder : this.getMatterStacksHolders()) {
                        if (matterStack.isEmpty() || matterStacksHolder.getLevel() != level || !matterStacksHolder.getLevel().isLoaded(matterStacksHolder.getPos()) || !((destination = matterStacksHolder.getLevel().getBlockEntity(matterStacksHolder.getPos())) instanceof IMatterTanksConsumer)) continue;
                        consumer = (IMatterTanksConsumer)destination;
                        for (IMatterTank iMatterTank : consumer.getTanks()) {
                            if (matterStack.isEmpty() || !iMatterTank.getMatter().getMatterType().equals(matterStack.getMatterType())) continue;
                            matterStack.setAmount(matterStack.getAmount() - iMatterTank.fill(matterStack, IFluidHandler.FluidAction.EXECUTE));
                        }
                    }
                    if (matterStack.isEmpty()) continue;
                    for (NetworkElement matterStacksHolder : this.getMatterStacksHolders()) {
                        if (matterStack.isEmpty() || matterStacksHolder.getLevel() != level || !matterStacksHolder.getLevel().isLoaded(matterStacksHolder.getPos()) || !((destination = matterStacksHolder.getLevel().getBlockEntity(matterStacksHolder.getPos())) instanceof IMatterTanksConsumer)) continue;
                        consumer = (IMatterTanksConsumer)destination;
                        for (IMatterTank iMatterTank : consumer.getTanks()) {
                            if (matterStack.isEmpty() || !iMatterTank.getMatter().isEmpty()) continue;
                            matterStack.setAmount(matterStack.getAmount() - iMatterTank.fill(matterStack, IFluidHandler.FluidAction.EXECUTE));
                        }
                    }
                }
            }
        }
        for (NetworkElement networkElement : this.terminals) {
            BlockEntity tile;
            if (!networkElement.getLevel().isLoaded(networkElement.getPos()) || !((tile = networkElement.getLevel().getBlockEntity(networkElement.getPos())) instanceof ReplicationTerminalBlockEntity)) continue;
            ReplicationTerminalBlockEntity terminalBlockEntity = (ReplicationTerminalBlockEntity)tile;
            terminalBlockEntity.getTerminalPlayerTracker().getPlayers().forEach(serverPlayer -> Replication.NETWORK.sendTo((Message)new TaskCancelPacket.Response(task, this.getId()), serverPlayer));
        }
    }

    public static class Factory
    implements NetworkFactory {
        private static final Logger LOGGER = LogManager.getLogger(Factory.class);

        public Network create(BlockPos pos) {
            return new MatterNetwork(pos, NetworkFactory.randomString((Random)new Random(), (int)8), 0, new ReplicationTaskManager());
        }

        public Network create(CompoundTag tag) {
            ReplicationTaskManager taskManager = new ReplicationTaskManager();
            taskManager.deserializeNBT((HolderLookup.Provider)ServerLifecycleHooks.getCurrentServer().registryAccess(), tag.getCompound("TaskManager"));
            MatterNetwork network = new MatterNetwork(BlockPos.of((long)tag.getLong("origin")), tag.getString("id"), tag.getInt("Power"), taskManager);
            LOGGER.debug("Deserialized matter network {} of type {}", (Object)network.getId(), (Object)network.getType().toString());
            return network;
        }
    }
}

