/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.registries.StarryRegistryKeys;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import java.time.Duration;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3079;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7737;

public class ClosestSphereCommand {
    private static final DynamicCommandExceptionType SPHERE_NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_54159((String)"commands.starry_skies.locate.sphere.not_found", (Object[])new Object[]{id}));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"starryskies_locate").requires(source -> source.method_9259(StarrySkies.CONFIG.locateSphereCommandRequiredPermissionLevel))).executes(context -> ClosestSphereCommand.execute((class_2168)context.getSource()))).then(class_2170.method_9244((String)"sphere", (ArgumentType)class_7737.method_45637((class_7157)registryAccess, StarryRegistryKeys.CONFIGURED_SPHERE)).executes(context -> ClosestSphereCommand.execute((class_2168)context.getSource(), class_7737.method_45636((CommandContext)context, (String)"sphere", StarryRegistryKeys.CONFIGURED_SPHERE)))));
    }

    private static int execute(class_2168 source) {
        class_2338 pos = class_2338.method_49638((class_2374)source.method_9222());
        Optional<Support.SphereDistance> result = Support.getClosestSphere(source.method_9225(), pos);
        if (result.isPresent()) {
            source.method_9226(() -> class_2561.method_43471((String)((Support.SphereDistance)result.get()).sphere.getDescription(source.method_30497())), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43471((String)"commands.starry_skies.locate.sphere.noop"), false);
        return 1;
    }

    private static int execute(class_2168 source, class_7737.class_7741<ConfiguredSphere<?, ?>> predicate) throws CommandSyntaxException {
        class_2338 pos = class_2338.method_49638((class_2374)source.method_9222());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
        Optional<Pair<class_2338, class_6880<ConfiguredSphere<?, ?>>>> result = Support.getClosestSphere3x3(source.method_9225(), pos, predicate, source.method_30497());
        stopwatch.stop();
        if (result.isPresent()) {
            return class_3079.method_45148((class_2168)source, predicate, (class_2338)pos, result.get(), (String)"commands.starry_skies.locate.sphere.success", (boolean)true, (Duration)stopwatch.elapsed());
        }
        throw SPHERE_NOT_FOUND_EXCEPTION.create((Object)predicate.method_45650());
    }
}

