/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.data_loaders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7654;
import net.minecraft.class_7923;

public class WeightedBlockGroupDataLoader
extends class_4309<Entry>
implements IdentifiableResourceReloadListener {
    public static final String LOCATION = "starry_skies/weighted_block_group";
    public static final class_2960 ID = StarrySkies.id("starry_skies/weighted_block_group");
    public static final WeightedBlockGroupDataLoader INSTANCE = new WeightedBlockGroupDataLoader();
    protected static final Map<String, Map<class_2248, Float>> GROUPS = new Object2ObjectArrayMap();

    private WeightedBlockGroupDataLoader() {
        super(Entry.CODEC, class_7654.method_45114((String)LOCATION));
    }

    protected void apply(Map<class_2960, Entry> prepared, class_3300 manager, class_3695 profiler) {
        for (Map.Entry<class_2960, Entry> entry : prepared.entrySet()) {
            String group = entry.getValue().group;
            for (Map.Entry<class_2960, Float> e : entry.getValue().weightedBlockIDs.entrySet()) {
                Optional optionalBlock = class_7923.field_41175.method_17966(e.getKey());
                if (!optionalBlock.isPresent()) continue;
                class_2248 block = (class_2248)optionalBlock.get();
                float weight = e.getValue().floatValue();
                GROUPS.computeIfAbsent(group, k -> new Object2FloatArrayMap()).put(block, Float.valueOf(weight));
            }
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Map<class_2248, Float> get(String blockGroup) {
        return GROUPS.get(blockGroup);
    }

    public class_2680 getEntry(String group, class_5819 random) {
        Map<class_2248, Float> weightedBlocks = this.get(group);
        if (weightedBlocks == null) {
            StarrySkies.LOGGER.warn("Trying to query a nonexistent WeightedBlockGroup: {}", (Object)group);
            StarrySkies.LOGGER.error(Arrays.toString(Thread.currentThread().getStackTrace()));
            return class_2246.field_10124.method_9564();
        }
        if (weightedBlocks.isEmpty()) {
            StarrySkies.LOGGER.warn("Trying to query an empty WeightedBlockGroup: {}", (Object)group);
            StarrySkies.LOGGER.error(Arrays.toString(Thread.currentThread().getStackTrace()));
            return class_2246.field_10124.method_9564();
        }
        return Support.getWeightedRandom(weightedBlocks, random).method_9564();
    }

    public record Entry(String group, Map<class_2960, Float> weightedBlockIDs) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(Entry::group), (App)Codec.unboundedMap((Codec)class_2960.field_25139, (Codec)Codec.FLOAT).fieldOf("blocks").forGetter(Entry::weightedBlockIDs)).apply((Applicative)instance, Entry::new));
    }
}

