/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.decorators;

import com.mojang.serialization.Codec;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.SphereDecorator;
import de.dafuqs.starryskies.worldgen.SphereFeatureContext;
import de.dafuqs.starryskies.worldgen.decorators.CenterPondDecoratorConfig;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class CenterPondDecorator
extends SphereDecorator<CenterPondDecoratorConfig> {
    public CenterPondDecorator(Codec<CenterPondDecoratorConfig> codec) {
        super(codec);
    }

    @Override
    public boolean generate(SphereFeatureContext<CenterPondDecoratorConfig> context) {
        class_5281 world = context.getWorld();
        PlacedSphere<?> sphere = context.getSphere();
        class_1923 origin = context.getChunkPos();
        class_5819 random = context.getRandom();
        CenterPondDecoratorConfig config = context.getConfig();
        if (!sphere.isCenterInChunk(origin)) {
            return false;
        }
        if (sphere.getRadius() > 9) {
            int pondRadius = (int)((double)sphere.getRadius() / 2.5);
            class_2338 sphereTop = sphere.getPosition().method_10086(sphere.getRadius());
            int waterLevelY = sphereTop.method_10264();
            boolean waterLevelSet = false;
            for (int x = -pondRadius - 1; x <= pondRadius; ++x) {
                for (int y = -pondRadius; y < 1; ++y) {
                    for (int z = -pondRadius - 1; z <= pondRadius; ++z) {
                        class_2338 currentBlockPos = sphereTop.method_10069(x, y, z);
                        if (!world.method_8320(currentBlockPos).method_26215()) continue;
                        waterLevelY = currentBlockPos.method_10264() - 1;
                        waterLevelSet = true;
                        break;
                    }
                    if (waterLevelSet) break;
                }
                if (waterLevelSet) break;
            }
            if ((double)(waterLevelY - sphere.getPosition().method_10264()) < (double)pondRadius * 1.5) {
                return false;
            }
            boolean hasLootChest = random.method_43057() < config.lootTableChance();
            class_2338 lootChestPosition = null;
            int pond15 = (int)Math.round((double)pondRadius * 1.5);
            for (int x = -pond15; x <= pond15; ++x) {
                for (int y = -pondRadius; y < pondRadius; ++y) {
                    for (int z = -pond15; z <= pond15; ++z) {
                        class_2338 currentBlockPos = sphereTop.method_10069(x, y, z);
                        class_2680 blockState = null;
                        if (currentBlockPos.method_10264() > waterLevelY) {
                            blockState = class_2246.field_10124.method_9564();
                        } else {
                            double distance = Support.getDistance(currentBlockPos, sphereTop);
                            double pondDistance = distance / (double)pondRadius;
                            if (pondDistance < 1.1) {
                                if (hasLootChest && x == 0 && z == 0 && lootChestPosition == null) {
                                    lootChestPosition = currentBlockPos;
                                }
                                blockState = config.fluidState();
                            } else if (pondDistance < 1.7) {
                                blockState = config.beachState();
                            }
                        }
                        if (blockState == null || world.method_8320(currentBlockPos).method_26215()) continue;
                        world.method_8652(currentBlockPos, blockState, 3);
                    }
                }
            }
            if (lootChestPosition != null) {
                this.placeLootChest(world, lootChestPosition, config.lootTable(), random);
            }
        }
        return true;
    }
}

