/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starryskies.worldgen.spheres;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.starryskies.StarrySkies;
import de.dafuqs.starryskies.Support;
import de.dafuqs.starryskies.state_providers.SphereStateProvider;
import de.dafuqs.starryskies.worldgen.ConfiguredSphere;
import de.dafuqs.starryskies.worldgen.ConfiguredSphereDecorator;
import de.dafuqs.starryskies.worldgen.PlacedSphere;
import de.dafuqs.starryskies.worldgen.Sphere;
import de.dafuqs.starryskies.worldgen.SphereConfig;
import de.dafuqs.starryskies.worldgen.SphereEntitySpawnDefinition;
import de.dafuqs.starryskies.worldgen.spheres.ShellSphere;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2633;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3545;
import net.minecraft.class_4651;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_5863;
import net.minecraft.class_6012;
import net.minecraft.class_6017;
import net.minecraft.class_6880;

public class StructureInteriorSphere
extends ShellSphere<Config> {
    private static final int STRUCTURE_SIZE = 9;

    public StructureInteriorSphere(Codec<Config> codec) {
        super(codec);
    }

    @Override
    public PlacedSphere<?> generate(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, Config config, class_2919 random, class_5455 registryManager, class_2338 pos, float radius) {
        return new Placed(configuredSphere, radius, configuredSphere.getDecorators(random), configuredSphere.getSpawns(random), random, config.innerBlock.getForSphere((class_5819)random, pos), config.shellBlock.getForSphere((class_5819)random, pos), config.shellThickness.method_35008((class_5819)random), config.shellThickness.method_35008((class_5819)random), config.centerStructures, config.outerStructures);
    }

    public static class Placed
    extends ShellSphere.Placed<Config> {
        protected final float shellRadius;
        protected final class_6012<class_2960> centerStructures;
        protected final class_6012<class_2960> outerStructures;

        public Placed(ConfiguredSphere<? extends Sphere<Config>, Config> configuredSphere, float radius, List<class_6880<ConfiguredSphereDecorator<?, ?>>> decorators, List<class_3545<class_1299<?>, Integer>> spawns, class_2919 random, class_4651 innerBlock, class_4651 shellBlock, int shellRadius, float shellRadius1, class_6012<class_2960> centerStructures, class_6012<class_2960> outerStructures) {
            super(configuredSphere, radius, decorators, spawns, random, innerBlock, shellBlock, shellRadius);
            this.shellRadius = shellRadius1;
            this.centerStructures = centerStructures;
            this.outerStructures = outerStructures;
        }

        @Override
        public String getDescription(class_5455 registryManager) {
            return "+++ StructureInteriorSphere +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nTemplateID: " + String.valueOf(this.getID(registryManager)) + "\nRadius: " + this.radius + "\nShell: " + this.shellBlock.toString() + " (Radius: " + this.shellRadius + ")\nCore: " + this.innerBlock.toString();
        }

        @Override
        public void decorate(class_5281 world, class_2338 origin, class_5819 random) {
            super.decorate(world, origin, random);
            class_3485 templateManager = world.method_8503().method_27727();
            class_1923 chunkPos = new class_1923(origin);
            class_2338.class_2339 mutable = new class_2338.class_2339();
            int pivot = 4;
            int iMaxRadius = (int)(this.radius - this.shellRadius) - pivot - 1;
            int step = 10;
            int start = (int)(this.radius - this.shellRadius) / step * step;
            for (int x2 = this.position.method_10263() - start; x2 <= this.position.method_10263() + start; x2 += step) {
                for (int y2 = this.position.method_10264() - start; y2 <= this.position.method_10264() + start; y2 += step) {
                    for (int z2 = this.position.method_10260() - start; z2 <= this.position.method_10260() + start; z2 += step) {
                        long d = Math.round(Support.getDistance(this.position.method_10263(), this.position.method_10264(), this.position.method_10260(), x2, y2, z2));
                        if (d >= (long)iMaxRadius) continue;
                        mutable.method_10103(x2, y2, z2);
                        if (!Support.isBlockPosInChunkPos(chunkPos, (class_2338)mutable)) continue;
                        class_6012<class_2960> structurePool = d == 0L ? this.centerStructures : this.outerStructures;
                        class_2960 structureId = (class_2960)structurePool.method_66216(random);
                        class_3499 template = templateManager.method_15094(structureId).orElse(null);
                        if (template != null) {
                            class_2338 set = mutable.method_10103(x2 - pivot, y2, z2 - pivot).method_10062();
                            class_3492 structurePlacementData = new class_3492().method_15123(class_2470.field_11467).method_15133(false);
                            template.method_15172((class_5425)world, set, set, structurePlacementData, class_2633.method_20048((long)this.position.method_10063()), 2);
                            continue;
                        }
                        StarrySkies.LOGGER.error("Trying to place a nonexistent structure template: {}", (Object)structureId);
                    }
                }
            }
        }
    }

    public static class Config
    extends ShellSphere.Config {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SphereConfig.CONFIG_CODEC.forGetter(config -> config), (App)SphereStateProvider.CODEC.fieldOf("main_block").forGetter(config -> config.innerBlock), (App)SphereStateProvider.CODEC.fieldOf("shell_block").forGetter(config -> config.shellBlock), (App)class_6017.field_33451.fieldOf("shell_thickness").forGetter(config -> config.shellThickness), (App)class_6012.method_34991((Codec)class_2960.field_25139).fieldOf("center_structures").forGetter(config -> config.centerStructures), (App)class_6012.method_34991((Codec)class_2960.field_25139).fieldOf("structures").forGetter(config -> config.outerStructures)).apply((Applicative)instance, (sphereConfig, innerBlock, shellBlock, shellThickness, centerStructures, outerStructures) -> new Config(sphereConfig.size, sphereConfig.decorators, sphereConfig.spawns, sphereConfig.generation, (SphereStateProvider)innerBlock, (SphereStateProvider)shellBlock, (class_6017)shellThickness, (class_6012<class_2960>)centerStructures, (class_6012<class_2960>)outerStructures)));
        protected final class_6017 shellThickness;
        protected final class_6012<class_2960> centerStructures;
        protected final class_6012<class_2960> outerStructures;

        public Config(class_5863 size, Map<class_6880<ConfiguredSphereDecorator<?, ?>>, Float> decorators, List<SphereEntitySpawnDefinition> spawns, Optional<SphereConfig.Generation> generation, SphereStateProvider innerBlock, SphereStateProvider shellBlock, class_6017 shellThickness, class_6012<class_2960> centerStructures, class_6012<class_2960> outerStructures) {
            super(size, decorators, spawns, generation, innerBlock, shellBlock, shellThickness);
            this.shellThickness = shellThickness;
            this.centerStructures = centerStructures;
            this.outerStructures = outerStructures;
        }
    }
}

