/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasyfurniture.dunmer.block;

import dev.apexstudios.apexcore.lib.multiblock.MultiBlock;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlockProperties;
import dev.apexstudios.apexcore.lib.multiblock.MultiBlockProperty;
import dev.apexstudios.apexcore.lib.util.ApexShapes;
import dev.apexstudios.fantasyfurniture.block.OvenBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class DunmerOvenBlock
extends OvenBlock
implements MultiBlock {
    public static final VoxelShape SHAPE = ApexShapes.join((VoxelShape)DunmerOvenBlock.box((double)12.5, (double)0.0, (double)6.5, (double)15.5, (double)3.0, (double)9.5), (VoxelShape[])new VoxelShape[]{DunmerOvenBlock.box((double)-15.5, (double)0.0, (double)6.5, (double)-12.5, (double)3.0, (double)9.5), DunmerOvenBlock.box((double)-15.0, (double)3.0, (double)7.0, (double)-13.0, (double)16.0, (double)9.0), DunmerOvenBlock.box((double)13.0, (double)3.0, (double)7.0, (double)15.0, (double)16.0, (double)9.0), DunmerOvenBlock.box((double)-16.0, (double)12.0, (double)7.0, (double)16.0, (double)14.0, (double)9.0), DunmerOvenBlock.box((double)-5.0, (double)10.5, (double)5.5, (double)5.0, (double)15.5, (double)10.5), DunmerOvenBlock.box((double)-6.0, (double)0.0, (double)2.0, (double)6.0, (double)3.0, (double)14.0)});

    public DunmerOvenBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPE);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)this.getMultiBlockProperty(), (Comparable)Integer.valueOf(0)));
    }

    public MultiBlockProperty getMultiBlockProperty() {
        return MultiBlockProperties.MB_1x1x2;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getMultiBlockProperty()});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState placementBlockState = super.getStateForPlacement(context);
        if (placementBlockState == null || !MultiBlock.canPlace((BlockPlaceContext)context, (BlockState)placementBlockState)) {
            return null;
        }
        return placementBlockState;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, blockState, placer, stack);
        MultiBlock.setBlockStates((Level)level, (BlockPos)pos, (BlockState)blockState);
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState blockState) {
        super.destroy(level, pos, blockState);
        MultiBlock.destroyBlocks((LevelAccessor)level, (BlockPos)pos, (BlockState)blockState);
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState blockState) {
        super.spawnDestroyParticles(level, player, pos, blockState);
        MultiBlock.spawnDestroyParticles((LevelAccessor)level, (BlockPos)pos, (BlockState)blockState, (Entity)player);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return (Integer)blockState.getValue((Property)this.getMultiBlockProperty()) == 0 ? super.newBlockEntity(pos, blockState) : null;
    }

    protected void affectNeighborsAfterRemoval(BlockState blockState, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        super.affectNeighborsAfterRemoval(blockState, level, pos, movedByPiston);
        MultiBlockProperty property = this.getMultiBlockProperty();
        int index = (Integer)blockState.getValue((Property)property);
        MultiBlock.forEachPos((BlockPos)pos, (BlockState)blockState, (otherPos, otherBlockState) -> {
            if (index != (Integer)otherBlockState.getValue((Property)property)) {
                level.updateNeighbourForOutputSignal(otherPos, otherBlockState.getBlock());
            }
        });
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos, Direction facing) {
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)blockEntity);
    }

    protected boolean triggerEvent(BlockState blockState, Level level, BlockPos pos, int id, int param) {
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
        return blockEntity != null && blockEntity.triggerEvent(id, param);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState blockState, Level level, BlockPos pos) {
        MenuProvider provider;
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos, (BlockState)blockState);
        return blockEntity instanceof MenuProvider ? (provider = (MenuProvider)blockEntity) : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level lvl, BlockState state, BlockEntityType<T> blockEntityType) {
        BlockEntityTicker vanillaTicker = (Integer)state.getValue((Property)this.getMultiBlockProperty()) == 0 ? super.getTicker(lvl, state, blockEntityType) : null;
        return vanillaTicker == null ? null : (level, pos, blockState, blockEntity) -> {
            Boolean wasLit = (Boolean)blockState.getValue((Property)LIT);
            vanillaTicker.tick(level, pos, blockState, blockEntity);
            Boolean isLit = (Boolean)level.getBlockState(pos).getValueOrElse((Property)LIT, (Comparable)wasLit);
            if (isLit == wasLit) {
                return;
            }
            int index = MultiBlock.getIndex((BlockState)blockState);
            MultiBlock.forEachPos((BlockPos)pos, (BlockState)blockState, (otherPos, otherBlockState) -> {
                if (index != MultiBlock.getIndex((BlockState)otherBlockState)) {
                    level.setBlockAndUpdate(otherPos, (BlockState)otherBlockState.setValue((Property)LIT, (Comparable)isLit));
                }
            });
        };
    }

    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = MultiBlock.getBlockEntity((BlockGetter)level, (BlockPos)pos);
        if (blockEntity instanceof SmokerBlockEntity) {
            SmokerBlockEntity blockEntity2 = (SmokerBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
            player.awardStat(Stats.INTERACT_WITH_SMOKER);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        if (!((Boolean)blockState.getValue((Property)LIT)).booleanValue() || MultiBlock.getIndex((BlockState)blockState) != 0) {
            return;
        }
        Direction facing = ((Direction)blockState.getValue((Property)FACING)).getCounterClockWise();
        double x = (double)pos.getX() + 0.5 + 0.5 * (double)facing.getStepX();
        double y = (double)pos.getY() + 0.15;
        double z = (double)pos.getZ() + 0.5 + 0.5 * (double)facing.getStepZ();
        if (random.nextDouble() < 0.1) {
            level.playLocalSound(x, y, z, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y + 1.1, z, 0.0, 0.0, 0.0);
    }
}

