/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.survivalDebugStick;

import de.scholle.survivalDebugStick.DebugStickListener;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SurvivalDebugStick
extends JavaPlugin
implements Listener {
    public void onEnable() {
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new DebugStickListener(this), (Plugin)this);
        if (this.getConfig().getBoolean("Debug_stick_craft.enabled")) {
            this.createDebugStickRecipe();
        }
        this.getLogger().info("SurvivalDebugStick aktiviert!");
    }

    private void createDebugStickRecipe() {
        FileConfiguration config = this.getConfig();
        HashMap<Character, Material> ingredientMap = new HashMap<Character, Material>();
        config.getConfigurationSection("Debug_stick_craft.ingredient").getKeys(false).forEach(key -> {
            String materialName = config.getString("Debug_stick_craft.ingredient." + key);
            Material mat = Material.matchMaterial((String)materialName);
            if (mat != null) {
                ingredientMap.put(Character.valueOf(key.charAt(0)), mat);
            } else {
                this.getLogger().warning("Material " + materialName + " konnte nicht gefunden werden!");
            }
        });
        ItemStack debugStick = new ItemStack(Material.DEBUG_STICK);
        ItemMeta meta = debugStick.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7aSurvival Debug Stick");
            debugStick.setItemMeta(meta);
        }
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)this, "survival_debug_stick"), debugStick);
        recipe.shape(new String[]{config.getString("Debug_stick_craft.shape.line1", ""), config.getString("Debug_stick_craft.shape.line2", ""), config.getString("Debug_stick_craft.shape.line3", "")});
        ingredientMap.forEach((arg_0, arg_1) -> ((ShapedRecipe)recipe).setIngredient(arg_0, arg_1));
        Bukkit.addRecipe((Recipe)recipe);
        this.getLogger().info("Debug Stick Rezept hinzugef\u00fcgt!");
    }
}

