/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.provinceofmusic.POMConfigObject;
import com.provinceofmusic.background.PackUpgrader;
import com.provinceofmusic.background.RamManager;
import com.provinceofmusic.background.WMRUpdater;
import com.provinceofmusic.jukebox.NoteReplacer;
import com.provinceofmusic.jukebox.SamplePack;
import com.provinceofmusic.jukebox.Sampler;
import com.provinceofmusic.listeners.NoteListenerHelper;
import com.provinceofmusic.recorder.DebugMode;
import com.provinceofmusic.recorder.MusicRecorder;
import com.provinceofmusic.screen.ConfigScreen;
import com.provinceofmusic.screen.POMSetupScreen;
import com.provinceofmusic.screen.SamplePackEditor;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.CottonClientScreen;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ProvinceOfMusicClient
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"provinceofmusic");
    public static MusicRecorder musicRecorder = new MusicRecorder();
    public static NoteReplacer noteReplacer = new NoteReplacer();
    public static class_304 openConfigScreenBinding;
    public static class_304 openSamplePackConfigScreenBinding;
    DebugMode debugMode = new DebugMode();
    public static NoteListenerHelper noteListenerHelper;
    public static File recordedmusicdir;
    public static File exportedmusicdir;
    public static File playrulesheetsdir;
    public static File configsettingsdir;
    public static File samplepacksdir;
    public static POMConfigObject configSettings;
    public static int guiSize;
    private boolean popupShown = false;
    private boolean showPopup = false;

    public void onInitializeClient() {
        this.setupFiles();
        PackUpgrader.main();
        this.getConfigSettings();
        this.setupListeners();
        ProvinceOfMusicClient.setupCommands();
    }

    public void setupListeners() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            musicRecorder.PassTime();
            noteListenerHelper.tick();
            guiSize = (Integer)class_310.method_1551().field_1690.method_42474().method_41753() == 0 ? 3 : (Integer)class_310.method_1551().field_1690.method_42474().method_41753();
        });
        musicRecorder.main();
        if (RamManager.isRamGood()) {
            noteReplacer.main();
            Sampler.recycler.start();
            noteReplacer.RunSetup();
        } else {
            this.showPopup = true;
        }
        ClientTickEvents.START_WORLD_TICK.register(client -> {});
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (ProvinceOfMusicClient.configSettings.activeSamplePack != null && ProvinceOfMusicClient.configSettings.activeSamplePack.contains("Wynn Music Remastered") && !ProvinceOfMusicClient.configSettings.activeSamplePack.equals(WMRUpdater.currentVersion)) {
                class_5250 message = class_2561.method_43470((String)"[Click here to Update Wynn Music Remastered]").method_10862(class_2583.field_24360.method_10977(class_124.field_1054).method_10958(new class_2558(class_2558.class_2559.field_11750, "/updateWMR")));
                assert (client.field_1724 != null);
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)"You are running an outdated version of Wynn Music Remastered").method_10862(class_2583.field_24360.method_10977(class_124.field_1054)), false);
                client.field_1724.method_7353((class_2561)message, false);
            }
        });
        MusicRecorder.recordBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Record Midi", class_3675.class_307.field_1668, -1, "Province of Music"));
        NoteReplacer.replaceNoteBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Toggle Replace Music", class_3675.class_307.field_1668, -1, "Province of Music"));
        openConfigScreenBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Open POM Settings", class_3675.class_307.field_1668, -1, "Province of Music"));
        openSamplePackConfigScreenBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Open Sample Pack Config", class_3675.class_307.field_1668, -1, "Province of Music"));
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {});
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_442 && !this.popupShown && this.showPopup) {
                this.popupShown = true;
                class_310.method_1551().method_1507((class_437)new CottonClientScreen((GuiDescription)new POMSetupScreen(false)));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            SamplePack pack;
            if (openConfigScreenBinding.method_1436()) {
                class_310.method_1551().method_1507((class_437)new CottonClientScreen((GuiDescription)new ConfigScreen()));
            }
            if (openSamplePackConfigScreenBinding.method_1436() && ProvinceOfMusicClient.configSettings.activeSamplePack != null && SamplePack.getSamplePackAsFile(ProvinceOfMusicClient.configSettings.activeSamplePack).exists() && (pack = SamplePack.getSamplePack(SamplePack.getSamplePackAsFile(ProvinceOfMusicClient.configSettings.activeSamplePack))) != null) {
                class_310.method_1551().method_1507((class_437)new CottonClientScreen((GuiDescription)new SamplePackEditor(pack)));
            }
        });
    }

    public void setupFiles() {
        configsettingsdir = new File("provinceofmusic/");
        if (!configsettingsdir.exists()) {
            configsettingsdir.mkdirs();
        }
        if (!(recordedmusicdir = new File("provinceofmusic/recorded-music/")).exists()) {
            recordedmusicdir.mkdirs();
        }
        if (!(exportedmusicdir = new File("provinceofmusic/exported-music/")).exists()) {
            exportedmusicdir.mkdirs();
        }
        if (!(playrulesheetsdir = new File("provinceofmusic/playrulesheets/")).exists()) {
            playrulesheetsdir.mkdirs();
        }
        if (!(samplepacksdir = new File("provinceofmusic/samplepacks")).exists()) {
            samplepacksdir.mkdirs();
        }
    }

    public void getConfigSettings() {
        File jsonTemp = new File(String.valueOf(configsettingsdir) + "/configSettings.json");
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().serializeNulls();
        Gson gson = builder.create();
        try {
            configSettings = (POMConfigObject)gson.fromJson(Files.readString(jsonTemp.toPath(), Charset.defaultCharset()), POMConfigObject.class);
        }
        catch (IOException e) {
            configSettings = new POMConfigObject();
            ProvinceOfMusicClient.saveConfigSettings();
        }
        if (Objects.requireNonNull(samplepacksdir.listFiles()).length == 0 && !ProvinceOfMusicClient.configSettings.saidNoToDownload) {
            this.showPopup = true;
        }
    }

    public static void saveConfigSettings() {
        File jsonTemp = new File(String.valueOf(configsettingsdir) + "/configSettings.json");
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().serializeNulls();
        Gson gson = builder.create();
        try {
            FileWriter fileWriter = new FileWriter(jsonTemp);
            fileWriter.write(gson.toJson((Object)configSettings));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (ProvinceOfMusicClient.configSettings.activeSamplePack == null) {
            NoteReplacer.replaceMusic = false;
        } else if (RamManager.isRamGood()) {
            noteReplacer.RunSetup();
        }
    }

    public static void setupCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"updateWMR").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).getPlayer().method_7353((class_2561)class_2561.method_43470((String)"Updating..."), false);
            WMRUpdater.download();
            return 1;
        })));
    }

    static {
        noteListenerHelper = new NoteListenerHelper();
        guiSize = 1;
    }
}

