/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.background;

import com.provinceofmusic.ProvinceOfMusicClient;
import com.provinceofmusic.jukebox.NoteReplacer;
import com.provinceofmusic.jukebox.SamplePack;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class WMRUpdater {
    public static String link = "https://www.dropbox.com/scl/fi/4i80ci4ghjn8ehvrvp0cb/Wynn-Music-Remastered-1.3.0.zip?rlkey=gvi9gzfihie46hgprmiab0bsf&st=vdgzsxk9&dl=1";
    public static String currentVersion = "Wynn Music Remastered 1.3.0";

    public static void download() {
        String fileUrl = link;
        String destination = "provinceofmusic/downloaded.zip/";
        try (BufferedInputStream in = new BufferedInputStream(new URL(fileUrl).openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(destination);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                fileOutputStream.write(dataBuffer, 0, bytesRead);
            }
            ProvinceOfMusicClient.LOGGER.debug("Download completed: " + destination);
        }
        catch (IOException e) {
            ProvinceOfMusicClient.LOGGER.error("Download failed: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        String zipFilePath = destination;
        String destDirectory = "provinceofmusic/samplepacks";
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    File parentDir = new File(filePath).getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
                        int read;
                        byte[] bytesIn = new byte[4096];
                        while ((read = zipIn.read(bytesIn)) != -1) {
                            bos.write(bytesIn, 0, read);
                        }
                    }
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
            ProvinceOfMusicClient.LOGGER.debug("Unzip complete.");
        }
        catch (IOException e) {
            ProvinceOfMusicClient.LOGGER.error("Unzip failed: " + e.getMessage());
            e.printStackTrace();
            try {
                Files.delete(Path.of(destination, new String[0]));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return;
        }
        ProvinceOfMusicClient.configSettings.activeSamplePack = currentVersion;
        ProvinceOfMusicClient.saveConfigSettings();
        try {
            Files.delete(Path.of(destination, new String[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File[] files = ProvinceOfMusicClient.samplepacksdir.listFiles();
        assert (files != null);
        for (File file : files) {
            if (!file.getName().contains("Wynn Music Remastered") || file.getName().equals(currentVersion)) continue;
            try {
                ArrayList<File> filesToDelete = SamplePack.findAllFiles(file);
                for (File f : filesToDelete) {
                    Files.delete(f.toPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        NoteReplacer.replaceMusic = true;
    }
}

