/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.jukebox;

import com.provinceofmusic.ProvinceOfMusicClient;
import com.provinceofmusic.jukebox.Instrument;
import com.provinceofmusic.jukebox.InstrumentDef;
import com.provinceofmusic.jukebox.NoteSoundMidi;
import com.provinceofmusic.jukebox.NoteSoundMinecraft;
import com.provinceofmusic.jukebox.SamplePack;
import com.provinceofmusic.jukebox.Sampler;
import com.provinceofmusic.jukebox.SamplerReceiver;
import com.provinceofmusic.listeners.NoteListener;
import com.provinceofmusic.listeners.NoteListenerHelper;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2561;
import net.minecraft.class_304;

@Environment(value=EnvType.CLIENT)
public class NoteReplacer
implements NoteListener {
    public static class_304 replaceNoteBinding;
    public static ArrayList<Sampler> samplers;
    public static boolean replaceMusic;
    public static boolean interrupt;
    public static SamplePack pack;

    @Override
    public void onNotePlayed(NoteSoundMinecraft note) {
        if (!replaceMusic) {
            return;
        }
        NoteSoundMidi noteSoundMidi = new NoteSoundMidi(note);
        NoteReplacer.playMusicFrame(noteSoundMidi.instrument, noteSoundMidi.pitch, noteSoundMidi.volume);
    }

    public static void playMusicFrame(Instrument instrument, float pitch, int volume) {
        if (!interrupt) {
            block0: for (InstrumentDef instrumentDef : NoteReplacer.pack.instrumentDefs) {
                if (!instrumentDef.noteType.equals(instrument.registeredName)) continue;
                Path path = Path.of(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + NoteReplacer.pack.name + "/samples/" + instrumentDef.dir, new String[0]);
                System.out.println(path);
                if (samplers == null) continue;
                for (Sampler sampler : samplers) {
                    if (!sampler.sample.toPath().equals(path)) continue;
                    sampler.playNote(pitch, volume, instrumentDef);
                    continue block0;
                }
            }
        }
    }

    public static void main() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (replaceNoteBinding.method_1436()) {
                boolean bl = replaceMusic = !replaceMusic;
                assert (client.field_1724 != null);
                if (replaceMusic) {
                    ProvinceOfMusicClient.LOGGER.info("Playing Sample Pack music");
                    client.field_1724.method_7353(class_2561.method_30163((String)"Playing Sample Pack music"), false);
                    continue;
                }
                ProvinceOfMusicClient.LOGGER.info("Playing Default music");
                client.field_1724.method_7353(class_2561.method_30163((String)"Playing Default music"), false);
            }
        });
    }

    public void RunSetup() {
        if (ProvinceOfMusicClient.configSettings.activeSamplePack != null) {
            ProvinceOfMusicClient.LOGGER.debug("Trying to load SamplePack");
            if (ProvinceOfMusicClient.configSettings.activeSamplePack != null && SamplePack.getSamplePackAsFile(ProvinceOfMusicClient.configSettings.activeSamplePack).exists()) {
                Thread reload = new Thread(() -> {
                    interrupt = true;
                    if (samplers != null && !samplers.isEmpty()) {
                        for (Sampler s : samplers) {
                            for (SamplerReceiver s2 : s.samplerReceivers) {
                                s2.stopAll();
                            }
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (samplers != null && !samplers.isEmpty()) {
                        for (Sampler s : samplers) {
                            s.storeSampleReceivers();
                        }
                        samplers.clear();
                    }
                    System.gc();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    pack = SamplePack.getSamplePack(SamplePack.getSamplePackAsFile(ProvinceOfMusicClient.configSettings.activeSamplePack));
                    if (samplers == null || samplers.isEmpty()) {
                        for (InstrumentDef instrumentDef : NoteReplacer.pack.instrumentDefs) {
                            File file = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + NoteReplacer.pack.name + "/samples/" + instrumentDef.dir);
                            if (file.exists()) {
                                samplers.add(new Sampler(file));
                                continue;
                            }
                            ProvinceOfMusicClient.LOGGER.warn("sf2 file not found File: " + instrumentDef.dir + " Ignoring this instrument");
                        }
                    }
                    System.gc();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    interrupt = false;
                });
                reload.start();
            } else {
                ProvinceOfMusicClient.configSettings.activeSamplePack = null;
                ProvinceOfMusicClient.saveConfigSettings();
                ProvinceOfMusicClient.LOGGER.warn("SamplePack load failed (Replacing active SamplePack with no SamplePack)");
            }
        }
        NoteListenerHelper.addListener(this);
    }

    static {
        samplers = new ArrayList();
        replaceMusic = true;
        interrupt = false;
    }
}

