/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.jukebox;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.provinceofmusic.ProvinceOfMusicClient;
import com.provinceofmusic.jukebox.InstrumentDef;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SamplePack {
    public String name = "Unnamed";
    public String author = "None Listed";
    public ArrayList<InstrumentDef> instrumentDefs = new ArrayList();

    public ArrayList<File> getInstrumentFiles() {
        File folderTemp = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + this.name + "/samples");
        ArrayList<File> tempFiles = new ArrayList<File>();
        File[] files = folderTemp.listFiles();
        assert (files != null);
        for (File file : files) {
            tempFiles.add(file);
        }
        return tempFiles;
    }

    public void WriteSamplePack() {
        File folderTemp = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + this.name + "/");
        folderTemp.mkdirs();
        File folderTemp2 = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + this.name + "/samples");
        folderTemp2.mkdirs();
        File outputFile = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + this.name + "/pack.json");
        try {
            FileWriter fileWriter = new FileWriter(outputFile);
            fileWriter.write("null");
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File jsonTemp = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + this.name + "/pack.json");
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().serializeNulls();
        Gson gson = builder.create();
        try {
            FileWriter fileWriter = new FileWriter(jsonTemp);
            fileWriter.write(gson.toJson((Object)this));
            fileWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SamplePack getSamplePack(File in) {
        SamplePack out;
        File jsonTemp = new File(in.getPath() + "/pack.json");
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting().serializeNulls();
        Gson gson = builder.create();
        try {
            out = (SamplePack)gson.fromJson(Files.readString(jsonTemp.toPath(), Charset.defaultCharset()), SamplePack.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        out.name = in.getName();
        ProvinceOfMusicClient.LOGGER.info("Imported SamplePack Successfully");
        return out;
    }

    public static File getSamplePackAsFile(String name) {
        return new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + name);
    }

    public static void DeletePack(String name) {
        File file = SamplePack.getSamplePackAsFile(name);
        SamplePack samplePack = SamplePack.getSamplePack(file);
        samplePack.WriteSamplePack();
        try {
            ArrayList<File> filesToDelete = SamplePack.findAllFiles(file);
            for (File f : filesToDelete) {
                Files.delete(f.toPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void CreateNewPack() {
        SamplePack out = new SamplePack();
        out.WriteSamplePack();
    }

    public static ArrayList<File> findAllFiles(File in) {
        ArrayList<File> out = new ArrayList<File>();
        if (in.isDirectory()) {
            File[] insideFiles = in.listFiles();
            assert (insideFiles != null);
            for (File f : insideFiles) {
                ArrayList<File> temp = SamplePack.findAllFiles(f);
                out.addAll(temp);
            }
            out.add(in);
        } else {
            out.add(in);
        }
        return out;
    }

    public static void RenameSamplePack(SamplePack in, String name) {
        File ogFolder = SamplePack.getSamplePackAsFile(in.name);
        File newFileFolder = new File(ogFolder.getParent(), name);
        try {
            Files.move(ogFolder.toPath(), newFileFolder.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File og2 = new File(String.valueOf(ProvinceOfMusicClient.samplepacksdir) + "/" + name + "/pack.json");
        File newFile2 = new File(og2.getParent(), "pack.json");
        try {
            Files.move(og2.toPath(), newFile2.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayList<File> FetchSamplePackFiles() {
        ArrayList<File> tempFiles = new ArrayList<File>();
        int fileCount = ProvinceOfMusicClient.samplepacksdir.listFiles().length;
        for (int i = 0; i < fileCount; ++i) {
            tempFiles.add(ProvinceOfMusicClient.samplepacksdir.listFiles()[i]);
        }
        return tempFiles;
    }
}

