/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.jukebox;

import com.provinceofmusic.jukebox.InstrumentDef;
import com.provinceofmusic.jukebox.NoteReplacer;
import com.provinceofmusic.jukebox.SamplerReceiver;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Sampler {
    public String insFileName;
    public File sample;
    public ArrayList<SamplerReceiver> samplerReceivers = new ArrayList();
    public float newThreads = 0.0f;
    public static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    public static Thread recycler = new Thread(() -> {
        block2: while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            int i = 0;
            while (true) {
                if (i >= NoteReplacer.samplers.size()) continue block2;
                if (NoteReplacer.interrupt) {
                    i = 1000000;
                } else {
                    NoteReplacer.samplers.get(i).recycleExtraSampleReceivers();
                }
                ++i;
            }
            break;
        }
    });

    public void createNewReceiver() {
        SamplerReceiver temp = SamplerReceiver.retrieveSamplerReceiver(this);
        this.samplerReceivers.add(temp);
    }

    public Sampler(File insFile) {
        if (scheduler == null) {
            scheduler = Executors.newScheduledThreadPool(3);
        }
        this.sample = insFile;
        this.insFileName = insFile.getName();
        this.createNewReceiver();
    }

    public void playNote(float pitch, int volume, InstrumentDef instrumentDef) {
        for (SamplerReceiver receiver : this.samplerReceivers) {
            if (!receiver.playNote(pitch, volume, instrumentDef, false)) continue;
            return;
        }
        this.newThreads += 0.125f;
        if (!this.samplerReceivers.isEmpty()) {
            this.samplerReceivers.get((int)(Math.random() * (double)this.samplerReceivers.size())).playNote(pitch, volume, instrumentDef, true);
        }
        if (this.newThreads < -2.0f) {
            this.newThreads = -2.0f;
        }
        if (this.newThreads > 0.0f) {
            this.newThreads -= 1.0f;
            scheduler.schedule(() -> {
                try {
                    this.createNewReceiver();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
    }

    public void storeSampleReceivers() {
        for (SamplerReceiver sr : this.samplerReceivers) {
            sr.shutdown();
        }
        this.samplerReceivers.clear();
    }

    public void recycleExtraSampleReceivers() {
        for (int i = 0; i < this.samplerReceivers.size() - 1; ++i) {
            SamplerReceiver curSR = this.samplerReceivers.get(i);
            if (curSR.samplerReceiverLastPlayTime + 200000L >= System.currentTimeMillis()) continue;
            curSR.shutdown(false);
            this.samplerReceivers.remove(i);
            --i;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!NoteReplacer.interrupt) continue;
            i = 1000000;
        }
    }
}

