/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.jukebox;

import com.provinceofmusic.ProvinceOfMusicClient;
import com.provinceofmusic.jukebox.InstrumentDef;
import com.provinceofmusic.jukebox.Sampler;
import java.io.IOException;
import java.util.Stack;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3419;

@Environment(value=EnvType.CLIENT)
public class SamplerReceiver {
    public Sampler sampler = null;
    public Receiver receiver = null;
    public Synthesizer synth = null;
    public Soundbank soundbank = null;
    public int elapsedTimeTillFree = 300;
    public long[] channelsLastPlayTime = new long[16];
    public long samplerReceiverLastPlayTime = 0x3FFFFFFFFFFFFFFFL;
    public static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    public static Stack<SamplerReceiver> samplerReceiverPool = new Stack();
    public boolean ready = true;

    public int tryGetFreeChannel() {
        for (int i = 0; i < 16; ++i) {
            if (this.channelsLastPlayTime[i] >= System.currentTimeMillis() - (long)this.elapsedTimeTillFree) continue;
            this.channelsLastPlayTime[i] = System.currentTimeMillis();
            this.samplerReceiverLastPlayTime = System.currentTimeMillis();
            return i;
        }
        return -1;
    }

    public boolean playNote(float inPitch, int inVelocity, InstrumentDef instrumentDef, boolean override) {
        if (!this.ready) {
            return false;
        }
        int freeChannel = this.tryGetFreeChannel();
        if (freeChannel == -1) {
            if (!override) {
                return false;
            }
            freeChannel = (int)(Math.random() * 16.0);
        }
        int channel = freeChannel;
        float clampedVelocity = Math.max(0, Math.min(inVelocity, 100));
        float weightedVelocity = (float)(-1.0 * ((double)(1.0f / (100.0f + 2.0f * clampedVelocity)) * Math.pow(clampedVelocity - 100.0f, 2.0)) + 100.0);
        int velocity = (int)((float)Math.round(weightedVelocity) * instrumentDef.volume);
        float newPitchBend = inPitch - (float)((int)inPitch);
        int pitchBendValue = (int)(8192.0f + 4096.0f * newPitchBend);
        int lsb = pitchBendValue & 0x7F;
        int msb = pitchBendValue >> 7 & 0x7F;
        int pitch = instrumentDef.singlePitch ? 60 + instrumentDef.transpose : (int)inPitch + instrumentDef.transpose;
        if (pitch < 0 || pitch > 127) {
            ProvinceOfMusicClient.LOGGER.error("Note Pitch out of Range (Your transpose value is too extreme of a value. If not using single inPitch : originalPitch + transpose is > 127 or < 0. If using single inPitch : 60 + transpose is > 127 or < 0) Value: " + instrumentDef.transpose + "Note Type: " + instrumentDef.noteType);
            return true;
        }
        if (instrumentDef.volume < 0.0f || instrumentDef.volume > 1.0f) {
            ProvinceOfMusicClient.LOGGER.error("Note Volume out of Range (Your Volume value is too extreme of a value. Keep it between 0 and 1) Value: " + instrumentDef.volume + "Note Type: " + instrumentDef.noteType);
            return true;
        }
        if (this.receiver == null) {
            ProvinceOfMusicClient.LOGGER.error("Could not use Instrument. File could be missing or corrupt. File: " + this.sampler.insFileName + "Note Type: " + instrumentDef.noteType);
            return true;
        }
        float volume = class_310.method_1551().field_1690.method_1630(class_3419.field_15247) * class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
        try {
            ShortMessage noteOn = new ShortMessage();
            ShortMessage pitchBend = new ShortMessage();
            ShortMessage volumeChange = new ShortMessage();
            ShortMessage reverb = new ShortMessage();
            pitchBend.setMessage(224, 0, lsb, msb);
            noteOn.setMessage(144, channel, pitch, velocity);
            volumeChange.setMessage(176, channel, 7, (int)(volume * 127.0f));
            reverb.setMessage(176, channel, 91, 50);
            this.receiver.send(noteOn, -1L);
            this.receiver.send(pitchBend, -1L);
            this.receiver.send(volumeChange, -1L);
            this.receiver.send(reverb, -1L);
            scheduler.schedule(() -> {
                try {
                    ShortMessage off = new ShortMessage();
                    off.setMessage(128, channel, pitch, 0);
                    this.receiver.send(off, -1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 200L, TimeUnit.MILLISECONDS);
        }
        catch (InvalidMidiDataException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void stopAll() {
        try {
            for (int ch = 0; ch < 16; ++ch) {
                for (int i = 0; i < 128; ++i) {
                    ShortMessage off = new ShortMessage();
                    off.setMessage(128, ch, i, 0);
                    this.receiver.send(off, -1L);
                }
                ShortMessage controlChange1 = new ShortMessage();
                controlChange1.setMessage(128, ch, 123, 0);
                ShortMessage controlChange2 = new ShortMessage();
                controlChange2.setMessage(128, ch, 64, 0);
                this.receiver.send(controlChange1, -1L);
                this.receiver.send(controlChange2, -1L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startup(Sampler inSampler) {
        this.ready = false;
        this.sampler = inSampler;
        try {
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
            this.synth.unloadAllInstruments(this.synth.getDefaultSoundbank());
            this.soundbank = MidiSystem.getSoundbank(this.sampler.sample);
            this.synth.loadAllInstruments(this.soundbank);
            this.receiver = this.synth.getReceiver();
            this.ready = true;
        }
        catch (IOException | InvalidMidiDataException | MidiUnavailableException e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean instant) {
        this.sampler = null;
        this.synth.unloadAllInstruments(this.soundbank);
        if (!instant) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.soundbank = null;
        this.receiver.close();
        if (!instant) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.synth.close();
        if (!instant) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.synth = null;
        this.receiver = null;
        samplerReceiverPool.add(this);
        System.gc();
    }

    public static SamplerReceiver retrieveSamplerReceiver(Sampler inSampler) {
        SamplerReceiver out = samplerReceiverPool.isEmpty() ? new SamplerReceiver() : samplerReceiverPool.pop();
        out.startup(inSampler);
        return out;
    }
}

