/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.NoteOn;
import com.provinceofmusic.midi.event.meta.EndOfTrack;
import com.provinceofmusic.midi.event.meta.Tempo;
import com.provinceofmusic.midi.event.meta.TimeSignature;
import com.provinceofmusic.midi.util.MidiUtil;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.TreeSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MidiTrack {
    private static final boolean VERBOSE = false;
    public static final byte[] IDENTIFIER = new byte[]{77, 84, 114, 107};
    private int mSize = 0;
    private boolean mSizeNeedsRecalculating = false;
    private boolean mClosed = false;
    private long mEndOfTrackDelta = 0L;
    private TreeSet<MidiEvent> mEvents = new TreeSet();

    public static MidiTrack createTempoTrack() {
        MidiTrack T = new MidiTrack();
        T.insertEvent(new TimeSignature());
        T.insertEvent(new Tempo());
        return T;
    }

    public MidiTrack() {
    }

    public MidiTrack(InputStream in) throws IOException {
        this();
        byte[] buffer = new byte[4];
        in.read(buffer);
        if (!MidiUtil.bytesEqual(buffer, IDENTIFIER, 0, 4)) {
            System.err.println("Track identifier did not match MTrk!");
            return;
        }
        in.read(buffer);
        this.mSize = MidiUtil.bytesToInt(buffer, 0, 4);
        buffer = new byte[this.mSize];
        in.read(buffer);
        this.readTrackData(buffer);
    }

    private void readTrackData(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        long totalTicks = 0L;
        while (((InputStream)in).available() > 0) {
            VariableLengthInt delta = new VariableLengthInt(in);
            MidiEvent E = MidiEvent.parseEvent(totalTicks += (long)delta.getValue(), delta.getValue(), in);
            if (E == null) {
                System.out.println("Event skipped!");
                continue;
            }
            if (E.getClass().equals(EndOfTrack.class)) {
                this.mEndOfTrackDelta = E.getDelta();
                break;
            }
            this.mEvents.add(E);
        }
    }

    public TreeSet<MidiEvent> getEvents() {
        return this.mEvents;
    }

    public int getEventCount() {
        return this.mEvents.size();
    }

    public int getSize() {
        if (this.mSizeNeedsRecalculating) {
            this.recalculateSize();
        }
        return this.mSize;
    }

    public long getLengthInTicks() {
        if (this.mEvents.size() == 0) {
            return 0L;
        }
        MidiEvent E = this.mEvents.last();
        return E.getTick();
    }

    public long getEndOfTrackDelta() {
        return this.mEndOfTrackDelta;
    }

    public void setEndOfTrackDelta(long delta) {
        this.mEndOfTrackDelta = delta;
    }

    public void insertNote(int channel, int pitch, int velocity, long tick, long duration) {
        this.insertEvent(new NoteOn(tick, channel, pitch, velocity));
        this.insertEvent(new NoteOn(tick + duration, channel, pitch, 0));
    }

    public void insertEvent(MidiEvent newEvent) {
        if (newEvent == null) {
            return;
        }
        if (this.mClosed) {
            System.err.println("Error: Cannot add an event to a closed track.");
            return;
        }
        MidiEvent prev = null;
        MidiEvent next2 = null;
        try {
            Class<?> treeSet = Class.forName("java.util.TreeSet");
            Method floor = treeSet.getMethod("floor", Object.class);
            Method ceiling = treeSet.getMethod("ceiling", Object.class);
            prev = (MidiEvent)floor.invoke(this.mEvents, newEvent);
            next2 = (MidiEvent)ceiling.invoke(this.mEvents, newEvent);
        }
        catch (Exception e) {
            for (MidiEvent next2 : this.mEvents) {
                if (next2.getTick() > newEvent.getTick()) break;
                prev = next2;
                next2 = null;
            }
        }
        this.mEvents.add(newEvent);
        this.mSizeNeedsRecalculating = true;
        if (prev != null) {
            newEvent.setDelta(newEvent.getTick() - prev.getTick());
        } else {
            newEvent.setDelta(newEvent.getTick());
        }
        if (next2 != null) {
            next2.setDelta(next2.getTick() - newEvent.getTick());
        }
        this.mSize += newEvent.getSize();
        if (newEvent.getClass().equals(EndOfTrack.class)) {
            if (next2 != null) {
                throw new IllegalArgumentException("Attempting to insert EndOfTrack before an existing event. Use closeTrack() when finished with MidiTrack.");
            }
            this.mClosed = true;
        }
    }

    public boolean removeEvent(MidiEvent E) {
        Iterator<MidiEvent> it = this.mEvents.iterator();
        MidiEvent prev = null;
        MidiEvent curr = null;
        MidiEvent next = null;
        while (it.hasNext()) {
            next = it.next();
            if (E.equals(curr)) break;
            prev = curr;
            curr = next;
            next = null;
        }
        if (next == null) {
            return this.mEvents.remove(curr);
        }
        if (!this.mEvents.remove(curr)) {
            return false;
        }
        if (prev != null) {
            next.setDelta(next.getTick() - prev.getTick());
        } else {
            next.setDelta(next.getTick());
        }
        return true;
    }

    public void closeTrack() {
        long lastTick = 0L;
        if (this.mEvents.size() > 0) {
            MidiEvent last = this.mEvents.last();
            lastTick = last.getTick();
        }
        EndOfTrack eot = new EndOfTrack(lastTick + this.mEndOfTrackDelta, 0L);
        this.insertEvent(eot);
    }

    public void dumpEvents() {
        Iterator<MidiEvent> it = this.mEvents.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }

    private void recalculateSize() {
        this.mSize = 0;
        Iterator<MidiEvent> it = this.mEvents.iterator();
        MidiEvent last = null;
        while (it.hasNext()) {
            MidiEvent E = it.next();
            this.mSize += E.getSize();
            if (last != null && !E.requiresStatusByte(last)) {
                --this.mSize;
            }
            last = E;
        }
        this.mSizeNeedsRecalculating = false;
    }

    public void writeToFile(OutputStream out) throws IOException {
        if (!this.mClosed) {
            this.closeTrack();
        }
        if (this.mSizeNeedsRecalculating) {
            this.recalculateSize();
        }
        out.write(IDENTIFIER);
        out.write(MidiUtil.intToBytes(this.mSize, 4));
        Iterator<MidiEvent> it = this.mEvents.iterator();
        MidiEvent lastEvent = null;
        while (it.hasNext()) {
            MidiEvent event = it.next();
            event.writeToFile(out, event.requiresStatusByte(lastEvent));
            lastEvent = event;
        }
    }
}

