/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event;

import com.provinceofmusic.midi.event.ChannelEvent;
import com.provinceofmusic.midi.event.SystemExclusiveEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class MidiEvent
implements Comparable<MidiEvent> {
    protected long mTick;
    protected VariableLengthInt mDelta;
    private static int sId = -1;
    private static int sType = -1;
    private static int sChannel = -1;

    public MidiEvent(long tick, long delta) {
        this.mTick = tick;
        this.mDelta = new VariableLengthInt((int)delta);
    }

    public long getTick() {
        return this.mTick;
    }

    public long getDelta() {
        return this.mDelta.getValue();
    }

    public void setDelta(long d) {
        this.mDelta.setValue((int)d);
    }

    protected abstract int getEventSize();

    public int getSize() {
        return this.getEventSize() + this.mDelta.getByteCount();
    }

    public boolean requiresStatusByte(MidiEvent prevEvent) {
        if (prevEvent == null) {
            return true;
        }
        if (this instanceof MetaEvent) {
            return true;
        }
        return !this.getClass().equals(prevEvent.getClass());
    }

    public void writeToFile(OutputStream out, boolean writeType) throws IOException {
        out.write(this.mDelta.getBytes());
    }

    public static final MidiEvent parseEvent(long tick, long delta, InputStream in) throws IOException {
        in.mark(1);
        boolean reset = false;
        int id = in.read();
        if (!MidiEvent.verifyIdentifier(id)) {
            in.reset();
            reset = true;
        }
        if (sType >= 8 && sType <= 14) {
            return ChannelEvent.parseChannelEvent(tick, delta, sType, sChannel, in);
        }
        if (sId == 255) {
            return MetaEvent.parseMetaEvent(tick, delta, in);
        }
        if (sId == 240 || sId == 247) {
            VariableLengthInt size = new VariableLengthInt(in);
            byte[] data = new byte[size.getValue()];
            in.read(data);
            return new SystemExclusiveEvent(sId, tick, delta, data);
        }
        System.out.println("Unable to handle status byte, skipping: " + sId);
        if (reset) {
            in.read();
        }
        return null;
    }

    private static boolean verifyIdentifier(int id) {
        sId = id;
        int type = id >> 4;
        int channel = id & 0xF;
        if (type >= 8 && type <= 14) {
            sId = id;
            sType = type;
            sChannel = channel;
        } else if (id == 255) {
            sId = id;
            sType = -1;
            sChannel = -1;
        } else if (type == 15) {
            sId = id;
            sType = type;
            sChannel = -1;
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mTick + " (" + this.mDelta.getValue() + "): " + this.getClass().getSimpleName();
    }
}

