/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SystemExclusiveEvent
extends MidiEvent {
    private int mType;
    private VariableLengthInt mLength;
    private byte[] mData;

    public SystemExclusiveEvent(int type, long tick, byte[] data) {
        this(type, tick, 0L, data);
    }

    public SystemExclusiveEvent(int type, long tick, long delta, byte[] data) {
        super(tick, delta);
        this.mType = type & 0xFF;
        if (this.mType != 240 && this.mType != 247) {
            this.mType = 240;
        }
        this.mLength = new VariableLengthInt(data.length);
        this.mData = data;
    }

    public byte[] getData() {
        return this.mData;
    }

    public void setData(byte[] data) {
        this.mLength.setValue(data.length);
        this.mData = data;
    }

    @Override
    public boolean requiresStatusByte(MidiEvent prevEvent) {
        return true;
    }

    @Override
    public void writeToFile(OutputStream out, boolean writeType) throws IOException {
        super.writeToFile(out, writeType);
        out.write(this.mType);
        out.write(this.mLength.getBytes());
        out.write(this.mData);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick < other.mTick) {
            return -1;
        }
        if (this.mTick > other.mTick) {
            return 1;
        }
        if (this.mDelta.getValue() > other.mDelta.getValue()) {
            return -1;
        }
        if (this.mDelta.getValue() < other.mDelta.getValue()) {
            return 1;
        }
        if (other instanceof SystemExclusiveEvent) {
            String curr = new String(this.mData);
            String comp = new String(((SystemExclusiveEvent)other).mData);
            return curr.compareTo(comp);
        }
        return 1;
    }

    @Override
    protected int getEventSize() {
        return 1 + this.mLength.getByteCount() + this.mData.length;
    }
}

