/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GenericMetaEvent
extends MetaEvent {
    private byte[] mData;

    protected GenericMetaEvent(long tick, long delta, MetaEvent.MetaEventData info) {
        super(tick, delta, info.type, info.length);
        this.mData = info.data;
        System.out.println("Warning: GenericMetaEvent used because type (" + info.type + ") wasn't recognized or unexpected data length (" + info.length.getValue() + ") for type.");
    }

    @Override
    protected int getEventSize() {
        return 2 + this.mLength.getByteCount() + this.mLength.getValue();
    }

    @Override
    protected void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(this.mLength.getBytes());
        out.write(this.mData);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        return 1;
    }
}

