/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.GenericMetaEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class KeySignature
extends MetaEvent {
    public static final int SCALE_MAJOR = 0;
    public static final int SCALE_MINOR = 1;
    private int mKey;
    private int mScale;

    public KeySignature(long tick, long delta, int key, int scale) {
        super(tick, delta, 89, new VariableLengthInt(2));
        this.setKey(key);
        this.mScale = scale;
    }

    public void setKey(int key) {
        this.mKey = (byte)key;
        if (this.mKey < -7) {
            this.mKey = -7;
        } else if (this.mKey > 7) {
            this.mKey = 7;
        }
    }

    public int getKey() {
        return this.mKey;
    }

    public void setScale(int scale) {
        this.mScale = scale;
    }

    public int getScale() {
        return this.mScale;
    }

    @Override
    protected int getEventSize() {
        return 5;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(2);
        out.write(this.mKey);
        out.write(this.mScale);
    }

    public static MetaEvent parseKeySignature(long tick, long delta, MetaEvent.MetaEventData info) {
        if (info.length.getValue() != 2) {
            return new GenericMetaEvent(tick, delta, info);
        }
        byte key = info.data[0];
        byte scale = info.data[1];
        return new KeySignature(tick, delta, (int)key, scale);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof KeySignature)) {
            return 1;
        }
        KeySignature o = (KeySignature)other;
        if (this.mKey != o.mKey) {
            return this.mKey < o.mKey ? -1 : 1;
        }
        if (this.mScale != o.mScale) {
            return this.mKey < o.mScale ? -1 : 1;
        }
        return 0;
    }
}

