/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.GenericMetaEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SequenceNumber
extends MetaEvent {
    private int mNumber;

    public SequenceNumber(long tick, long delta, int number) {
        super(tick, delta, 0, new VariableLengthInt(2));
        this.mNumber = number;
    }

    public int getMostSignificantBits() {
        return this.mNumber >> 8;
    }

    public int getLeastSignificantBits() {
        return this.mNumber & 0xFF;
    }

    public int getSequenceNumber() {
        return this.mNumber;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(2);
        out.write(this.getMostSignificantBits());
        out.write(this.getLeastSignificantBits());
    }

    public static MetaEvent parseSequenceNumber(long tick, long delta, MetaEvent.MetaEventData info) {
        if (info.length.getValue() != 2) {
            return new GenericMetaEvent(tick, delta, info);
        }
        byte msb = info.data[0];
        byte lsb = info.data[1];
        int number = (msb << 8) + lsb;
        return new SequenceNumber(tick, delta, number);
    }

    @Override
    protected int getEventSize() {
        return 5;
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof SequenceNumber)) {
            return 1;
        }
        SequenceNumber o = (SequenceNumber)other;
        if (this.mNumber != o.mNumber) {
            return this.mNumber < o.mNumber ? -1 : 1;
        }
        return 0;
    }
}

