/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.MidiUtil;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SequencerSpecificEvent
extends MetaEvent {
    private byte[] mData;

    public SequencerSpecificEvent(long tick, long delta, byte[] data) {
        super(tick, delta, 127, new VariableLengthInt(data.length));
        this.mData = data;
    }

    public void setData(byte[] data) {
        this.mData = data;
        this.mLength.setValue(this.mData.length);
    }

    public byte[] getData() {
        return this.mData;
    }

    @Override
    protected int getEventSize() {
        return 2 + this.mLength.getByteCount() + this.mData.length;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(this.mLength.getBytes());
        out.write(this.mData);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof SequencerSpecificEvent)) {
            return 1;
        }
        SequencerSpecificEvent o = (SequencerSpecificEvent)other;
        if (MidiUtil.bytesEqual(this.mData, o.mData, 0, this.mData.length)) {
            return 0;
        }
        return 1;
    }
}

