/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.GenericMetaEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class SmpteOffset
extends MetaEvent {
    public static final int FRAME_RATE_24 = 0;
    public static final int FRAME_RATE_25 = 1;
    public static final int FRAME_RATE_30_DROP = 2;
    public static final int FRAME_RATE_30 = 3;
    private FrameRate mFrameRate;
    private int mHours;
    private int mMinutes;
    private int mSeconds;
    private int mFrames;
    private int mSubFrames;

    public SmpteOffset(long tick, long delta, FrameRate fps, int hour, int min, int sec, int fr, int subfr) {
        super(tick, delta, 84, new VariableLengthInt(5));
        this.mFrameRate = fps;
        this.mHours = hour;
        this.mMinutes = min;
        this.mSeconds = sec;
        this.mFrames = fr;
        this.mSubFrames = subfr;
    }

    public void setFrameRate(FrameRate fps) {
        this.mFrameRate = fps;
    }

    public FrameRate getFrameRate() {
        return this.mFrameRate;
    }

    public void setHours(int h) {
        this.mHours = h;
    }

    public int getHours() {
        return this.mHours;
    }

    public void setMinutes(int m) {
        this.mMinutes = m;
    }

    public int getMinutes() {
        return this.mMinutes;
    }

    public void setSeconds(int s) {
        this.mSeconds = s;
    }

    public int getSeconds() {
        return this.mSeconds;
    }

    public void setFrames(int f) {
        this.mFrames = f;
    }

    public int getFrames() {
        return this.mFrames;
    }

    public void setSubFrames(int s) {
        this.mSubFrames = s;
    }

    public int getSubFrames() {
        return this.mSubFrames;
    }

    @Override
    protected int getEventSize() {
        return 8;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(5);
        out.write(this.mHours);
        out.write(this.mMinutes);
        out.write(this.mSeconds);
        out.write(this.mFrames);
        out.write(this.mSubFrames);
    }

    public static MetaEvent parseSmpteOffset(long tick, long delta, MetaEvent.MetaEventData info) {
        if (info.length.getValue() != 5) {
            return new GenericMetaEvent(tick, delta, info);
        }
        byte rrHours = info.data[0];
        int rr = rrHours >> 5;
        FrameRate fps = FrameRate.fromInt(rr);
        int hour = rrHours & 0x1F;
        byte min = info.data[1];
        byte sec = info.data[2];
        byte frm = info.data[3];
        byte sub = info.data[4];
        return new SmpteOffset(tick, delta, fps, hour, min, sec, frm, sub);
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof SmpteOffset)) {
            return 1;
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum FrameRate {
        FRAME_RATE_24(0),
        FRAME_RATE_25(1),
        FRAME_RATE_30_DROP(2),
        FRAME_RATE_30(3);

        public final int value;

        private FrameRate(int v) {
            this.value = v;
        }

        public static FrameRate fromInt(int val) {
            switch (val) {
                case 0: {
                    return FRAME_RATE_24;
                }
                case 1: {
                    return FRAME_RATE_25;
                }
                case 2: {
                    return FRAME_RATE_30_DROP;
                }
                case 3: {
                    return FRAME_RATE_30;
                }
            }
            return null;
        }
    }
}

