/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class TextualMetaEvent
extends MetaEvent {
    protected String mText;

    protected TextualMetaEvent(long tick, long delta, int type, String text) {
        super(tick, delta, type, new VariableLengthInt(text.length()));
        this.setText(text);
    }

    protected void setText(String t) {
        this.mText = t;
        this.mLength.setValue(t.getBytes().length);
    }

    protected String getText() {
        return this.mText;
    }

    @Override
    protected int getEventSize() {
        return 2 + this.mLength.getByteCount() + this.mLength.getValue();
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(this.mLength.getBytes());
        out.write(this.mText.getBytes());
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof TextualMetaEvent)) {
            return 1;
        }
        TextualMetaEvent o = (TextualMetaEvent)other;
        return this.mText.compareTo(o.mText);
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.mText;
    }
}

