/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.event.meta;

import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.meta.GenericMetaEvent;
import com.provinceofmusic.midi.event.meta.MetaEvent;
import com.provinceofmusic.midi.util.VariableLengthInt;
import java.io.IOException;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TimeSignature
extends MetaEvent {
    public static final int METER_EIGHTH = 12;
    public static final int METER_QUARTER = 24;
    public static final int METER_HALF = 48;
    public static final int METER_WHOLE = 96;
    public static final int DEFAULT_METER = 24;
    public static final int DEFAULT_DIVISION = 8;
    private int mNumerator;
    private int mDenominator;
    private int mMeter;
    private int mDivision;

    public TimeSignature() {
        this(0L, 0L, 4, 4, 24, 8);
    }

    public TimeSignature(long tick, long delta, int num, int den, int meter, int div) {
        super(tick, delta, 88, new VariableLengthInt(4));
        this.setTimeSignature(num, den, meter, div);
    }

    public void setTimeSignature(int num, int den, int meter, int div) {
        this.mNumerator = num;
        this.mDenominator = this.log2(den);
        this.mMeter = meter;
        this.mDivision = div;
    }

    public int getNumerator() {
        return this.mNumerator;
    }

    public int getDenominatorValue() {
        return this.mDenominator;
    }

    public int getRealDenominator() {
        return (int)Math.pow(2.0, this.mDenominator);
    }

    public int getMeter() {
        return this.mMeter;
    }

    public int getDivision() {
        return this.mDivision;
    }

    @Override
    protected int getEventSize() {
        return 7;
    }

    @Override
    public void writeToFile(OutputStream out) throws IOException {
        super.writeToFile(out);
        out.write(4);
        out.write(this.mNumerator);
        out.write(this.mDenominator);
        out.write(this.mMeter);
        out.write(this.mDivision);
    }

    public static MetaEvent parseTimeSignature(long tick, long delta, MetaEvent.MetaEventData info) {
        if (info.length.getValue() != 4) {
            return new GenericMetaEvent(tick, delta, info);
        }
        byte num = info.data[0];
        int den = info.data[1];
        byte met = info.data[2];
        byte fps = info.data[3];
        den = (int)Math.pow(2.0, den);
        return new TimeSignature(tick, delta, num, den, met, fps);
    }

    private int log2(int den) {
        switch (den) {
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.mNumerator + "/" + this.getRealDenominator();
    }

    @Override
    public int compareTo(MidiEvent other) {
        if (this.mTick != other.getTick()) {
            return this.mTick < other.getTick() ? -1 : 1;
        }
        if ((long)this.mDelta.getValue() != other.getDelta()) {
            return (long)this.mDelta.getValue() < other.getDelta() ? 1 : -1;
        }
        if (!(other instanceof TimeSignature)) {
            return 1;
        }
        TimeSignature o = (TimeSignature)other;
        if (this.mNumerator != o.mNumerator) {
            return this.mNumerator < o.mNumerator ? -1 : 1;
        }
        if (this.mDenominator != o.mDenominator) {
            return this.mDenominator < o.mDenominator ? -1 : 1;
        }
        return 0;
    }
}

