/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.examples;

import com.provinceofmusic.midi.MidiFile;
import com.provinceofmusic.midi.event.MidiEvent;
import com.provinceofmusic.midi.event.NoteOn;
import com.provinceofmusic.midi.event.meta.Tempo;
import com.provinceofmusic.midi.util.MidiEventListener;
import com.provinceofmusic.midi.util.MidiProcessor;
import java.io.File;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class EventPrinter
implements MidiEventListener {
    private String mLabel;

    public EventPrinter(String label) {
        this.mLabel = label;
    }

    @Override
    public void onStart(boolean fromBeginning) {
        if (fromBeginning) {
            System.out.println(this.mLabel + " Started!");
        } else {
            System.out.println(this.mLabel + " resumed");
        }
    }

    @Override
    public void onEvent(MidiEvent event, long ms) {
        System.out.println(this.mLabel + " received event: " + String.valueOf(event));
    }

    @Override
    public void onStop(boolean finished) {
        if (finished) {
            System.out.println(this.mLabel + " Finished!");
        } else {
            System.out.println(this.mLabel + " paused");
        }
    }

    public static void main(String[] args) {
        MidiFile midi = null;
        try {
            midi = new MidiFile(new File("inputmid.mid"));
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
        MidiProcessor processor = new MidiProcessor(midi);
        EventPrinter ep = new EventPrinter("Individual Listener");
        processor.registerEventListener(ep, Tempo.class);
        processor.registerEventListener(ep, NoteOn.class);
        EventPrinter ep2 = new EventPrinter("Listener For All");
        processor.registerEventListener(ep2, MidiEvent.class);
        processor.start();
        try {
            Thread.sleep(10000L);
            processor.stop();
            Thread.sleep(10000L);
            processor.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

