/*
 * Decompiled with CFR 0.152.
 */
package com.provinceofmusic.midi.examples;

import com.provinceofmusic.midi.MidiFile;
import com.provinceofmusic.midi.MidiTrack;
import com.provinceofmusic.midi.event.NoteOff;
import com.provinceofmusic.midi.event.NoteOn;
import com.provinceofmusic.midi.event.meta.Tempo;
import com.provinceofmusic.midi.event.meta.TimeSignature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class MidiFileFromScratch {
    public static void main(String[] args) {
        MidiTrack tempoTrack = new MidiTrack();
        MidiTrack noteTrack = new MidiTrack();
        TimeSignature ts = new TimeSignature();
        ts.setTimeSignature(4, 4, 24, 8);
        Tempo t = new Tempo();
        t.setBpm(228.0f);
        tempoTrack.insertEvent(ts);
        tempoTrack.insertEvent(t);
        for (int i = 0; i < 80; ++i) {
            int channel = 0;
            int pitch = 1 + i;
            int velocity = 100;
            NoteOn on = new NoteOn(i * 480, channel, pitch, velocity);
            NoteOff off = new NoteOff(i * 480 + 120, channel, pitch, 0);
            noteTrack.insertEvent(on);
            noteTrack.insertEvent(off);
            noteTrack.insertNote(channel, pitch + 2, velocity, i * 480, 120L);
        }
        ArrayList<MidiTrack> tracks = new ArrayList<MidiTrack>();
        tracks.add(tempoTrack);
        tracks.add(noteTrack);
        MidiFile midi = new MidiFile(480, tracks);
        File output = new File("exampleout.mid");
        try {
            midi.writeToFile(output);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

